/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.Tombstone;
import org.hibernate.cache.infinispan.util.TombstoneUpdate;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.iteration.EntryIterable;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class TombstoneCallInterceptor
extends CallInterceptor {
    private static final Log log = LogFactory.getLog(TombstoneCallInterceptor.class);
    private static final UUID ZERO = new UUID(0L, 0L);
    private final BaseTransactionalDataRegion region;
    private final Metadata expiringMetadata;
    private Metadata defaultMetadata;
    private AdvancedCache cache;

    public TombstoneCallInterceptor(BaseTransactionalDataRegion region) {
        this.region = region;
        this.expiringMetadata = new EmbeddedMetadata.Builder().lifespan(region.getTombstoneExpiration(), TimeUnit.MILLISECONDS).build();
    }

    @Inject
    public void injectDependencies(AdvancedCache cache) {
        this.cache = cache;
    }

    @Start
    public void start() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.cacheConfiguration.expiration().lifespan()).maxIdle(this.cacheConfiguration.expiration().maxIdle()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        log.tracef("In cache %s(%d) applying update %s to %s", new Object[]{this.cache.getName(), this.region.getLastRegionInvalidation(), command.getValue(), e.getValue()});
        try {
            Object value = command.getValue();
            if (value instanceof TombstoneUpdate) {
                Object object = this.handleTombstoneUpdate(e, (TombstoneUpdate)value, command);
                return object;
            }
            if (value instanceof Tombstone) {
                Object object = this.handleTombstone(e, (Tombstone)value);
                return object;
            }
            if (value instanceof FutureUpdate) {
                Object object = this.handleFutureUpdate(e, (FutureUpdate)value, command);
                return object;
            }
            Object object = super.visitPutKeyValueCommand(ctx, command);
            return object;
        }
        finally {
            log.tracef("Result is %s", e.getValue());
        }
    }

    private Object handleFutureUpdate(MVCCEntry e, FutureUpdate futureUpdate, PutKeyValueCommand command) {
        Object storedValue = e.getValue();
        if (storedValue instanceof Tombstone) {
            Tombstone tombstone = (Tombstone)storedValue;
            this.setValue(e, tombstone.applyUpdate(futureUpdate.getUuid(), futureUpdate.getTimestamp(), futureUpdate.getValue()));
        } else {
            this.setFailed(command);
        }
        return null;
    }

    private Object handleTombstone(MVCCEntry e, Tombstone tombstone) {
        Object storedValue = e.getValue();
        if (storedValue instanceof Tombstone) {
            this.setValue(e, ((Tombstone)storedValue).merge(tombstone));
        } else {
            this.setValue(e, tombstone);
        }
        return null;
    }

    protected Object handleTombstoneUpdate(MVCCEntry e, TombstoneUpdate tombstoneUpdate, PutKeyValueCommand command) {
        Object storedValue = e.getValue();
        Object value = tombstoneUpdate.getValue();
        if (value == null) {
            if (storedValue == null || storedValue instanceof Tombstone) {
                this.setFailed(command);
            } else {
                this.setValue(e, new Tombstone(ZERO, tombstoneUpdate.getTimestamp()));
            }
        } else if (storedValue instanceof Tombstone) {
            Tombstone tombstone = (Tombstone)storedValue;
            if (tombstone.getLastTimestamp() < tombstoneUpdate.getTimestamp()) {
                this.setValue(e, value);
            }
        } else if (storedValue == null && this.region.getLastRegionInvalidation() < tombstoneUpdate.getTimestamp()) {
            this.setValue(e, value);
        }
        return null;
    }

    private Object setValue(MVCCEntry e, Object value) {
        if (e.isRemoved()) {
            e.setRemoved(false);
            e.setCreated(true);
            e.setValid(true);
        } else {
            e.setChanged(true);
        }
        if (value instanceof Tombstone) {
            e.setMetadata(this.expiringMetadata);
        } else {
            e.setMetadata(this.defaultMetadata);
        }
        return e.setValue(value);
    }

    private void setFailed(PutKeyValueCommand command) {
        command.setValueMatcher(ValueMatcher.MATCH_NEVER);
        try {
            command.perform(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        Set flags = command.getFlags();
        int size = 0;
        Map contextEntries = ctx.getLookedUpEntries();
        AdvancedCache decoratedCache = this.cache.getAdvancedCache().withFlags(flags != null ? flags.toArray(new Flag[flags.size()]) : null);
        try (EntryIterable iterable = decoratedCache.filterEntries((KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES);){
            for (CacheEntry entry : iterable) {
                if (entry.getValue() == null || size++ != Integer.MAX_VALUE) continue;
                Integer n = Integer.MAX_VALUE;
                return n;
            }
        }
        return size;
    }
}

