/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class SubclassPropertyMapper
implements ExtendedPropertyMapper {
    private ExtendedPropertyMapper main;
    private ExtendedPropertyMapper parentMapper;

    public SubclassPropertyMapper(ExtendedPropertyMapper main, ExtendedPropertyMapper parentMapper) {
        this.main = main;
        this.parentMapper = parentMapper;
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean parentDiffs = this.parentMapper.map(session, data, propertyNames, newState, oldState);
        boolean mainDiffs = this.main.map(session, data, propertyNames, newState, oldState);
        return parentDiffs || mainDiffs;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        boolean parentDiffs = this.parentMapper.mapToMapFromEntity(session, data, newObj, oldObj);
        boolean mainDiffs = this.main.mapToMapFromEntity(session, data, newObj, oldObj);
        return parentDiffs || mainDiffs;
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        this.parentMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj, oldObj);
        this.main.mapModifiedFlagsToMapFromEntity(session, data, newObj, oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        this.parentMapper.mapModifiedFlagsToMapForCollectionChange(collectionPropertyName, data);
        this.main.mapModifiedFlagsToMapForCollectionChange(collectionPropertyName, data);
    }

    @Override
    public void mapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        this.parentMapper.mapToEntityFromMap(enversService, obj, data, primaryKey, versionsReader, revision);
        this.main.mapToEntityFromMap(enversService, obj, data, primaryKey, versionsReader, revision);
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        List<PersistentCollectionChangeData> parentCollectionChanges = this.parentMapper.mapCollectionChanges(session, referencingPropertyName, newColl, oldColl, id);
        List<PersistentCollectionChangeData> mainCollectionChanges = this.main.mapCollectionChanges(session, referencingPropertyName, newColl, oldColl, id);
        if (parentCollectionChanges == null) {
            return mainCollectionChanges;
        }
        if (mainCollectionChanges != null) {
            parentCollectionChanges.addAll(mainCollectionChanges);
        }
        return parentCollectionChanges;
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, Class componentClass) {
        return this.main.addComponent(propertyData, componentClass);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.main.addComposite(propertyData, propertyMapper);
    }

    @Override
    public void add(PropertyData propertyData) {
        this.main.add(propertyData);
    }

    @Override
    public Map<PropertyData, PropertyMapper> getProperties() {
        HashMap<PropertyData, PropertyMapper> joinedProperties = new HashMap<PropertyData, PropertyMapper>();
        joinedProperties.putAll(this.parentMapper.getProperties());
        joinedProperties.putAll(this.main.getProperties());
        return joinedProperties;
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        for (PropertyData property : this.getProperties().keySet()) {
            if (!property.isUsingModifiedFlag()) continue;
            return true;
        }
        return false;
    }
}

