/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.jgroups.impl.AutoNodeSelector;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueTask;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JGroupsBackend
implements Backend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String JGROUPS_CONFIGURATION_SPACE = "jgroups";
    public static final String BLOCK_WAITING_ACK = "block_waiting_ack";
    public static final String DELEGATE_BACKEND = "delegate_backend";
    public static final String MESSAGE_TIMEOUT_MS = "messages_timeout";
    public static final int DEFAULT_MESSAGE_TIMEOUT = 20000;
    private Properties properties;
    private ServiceManager serviceManager;
    private MessageSenderService messageSender;
    private LuceneWorkSerializer luceneWorkSerializer;
    private NodeSelectorService masterNodeSelector;
    private String delegateBackendName;
    private boolean sync;
    private boolean block;
    private long messageTimeout;

    public void initialize(Properties properties, WorkerBuildContext context) {
        this.properties = properties;
        this.serviceManager = context.getServiceManager();
        this.messageSender = (MessageSenderService)this.serviceManager.requestService(MessageSenderService.class);
        this.luceneWorkSerializer = (LuceneWorkSerializer)this.serviceManager.requestService(LuceneWorkSerializer.class);
        this.masterNodeSelector = (NodeSelectorService)this.serviceManager.requestService(NodeSelectorService.class);
        this.sync = BackendFactory.isConfiguredAsSync((Properties)properties);
        MaskedProperty jgroupsProperties = new MaskedProperty(properties, JGROUPS_CONFIGURATION_SPACE);
        this.block = ConfigurationParseHelper.getBooleanValue((Properties)jgroupsProperties, (String)BLOCK_WAITING_ACK, (boolean)this.sync);
        this.messageTimeout = ConfigurationParseHelper.getLongValue((Properties)jgroupsProperties, (String)MESSAGE_TIMEOUT_MS, (long)20000L);
        this.delegateBackendName = ConfigurationParseHelper.getString((Properties)jgroupsProperties, (String)DELEGATE_BACKEND, (String)"local");
    }

    public void close() {
        this.masterNodeSelector = null;
        this.serviceManager.releaseService(NodeSelectorService.class);
        this.luceneWorkSerializer = null;
        this.serviceManager.releaseService(LuceneWorkSerializer.class);
        this.messageSender = null;
        this.serviceManager.releaseService(MessageSenderService.class);
        this.serviceManager = null;
    }

    public JGroupsBackendQueueProcessor createQueueProcessor(IndexManager indexManager, WorkerBuildContext context) {
        NodeSelectorStrategy selectionStrategy = this.createNodeSelectorStrategy(indexManager);
        String indexName = indexManager.getIndexName();
        JGroupsBackend.assertLegacyOptionsNotUsed(this.properties, indexName);
        this.masterNodeSelector.setNodeSelectorStrategy(indexName, selectionStrategy);
        selectionStrategy.viewAccepted(this.messageSender.getView());
        log.jgroupsBlockWaitingForAck(indexName, this.block);
        JGroupsBackendQueueTask jgroupsProcessor = new JGroupsBackendQueueTask(this.messageSender, indexManager, this.masterNodeSelector, this.luceneWorkSerializer, this.block, this.messageTimeout);
        JGroupsBackendQueueProcessor queueProcessor = new JGroupsBackendQueueProcessor(selectionStrategy, jgroupsProcessor, () -> this.createDelegateQueueProcessor(indexManager, context));
        return queueProcessor;
    }

    private BackendQueueProcessor createDelegateQueueProcessor(IndexManager indexManager, WorkerBuildContext context) {
        return BackendFactory.createBackend((String)this.delegateBackendName, (IndexManager)indexManager, (WorkerBuildContext)context, (Properties)this.properties);
    }

    protected NodeSelectorStrategy createNodeSelectorStrategy(IndexManager indexManager) {
        return new AutoNodeSelector(indexManager.getIndexName());
    }

    private static void assertLegacyOptionsNotUsed(Properties props, String indexName) {
        MaskedProperty jgroupsCfg = new MaskedProperty(props, "worker.backend.jgroups");
        if (jgroupsCfg.containsKey((Object)"configurationFile") || jgroupsCfg.containsKey((Object)"configurationXml") || jgroupsCfg.containsKey((Object)"configurationString") || jgroupsCfg.containsKey((Object)"clusterName")) {
            throw log.legacyJGroupsConfigurationDefined(indexName);
        }
    }
}

