/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.util.Map;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.jgroups.common.JGroupsCommonTest;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.junit.Assert;
import org.junit.Test;

public class InjectedChannelTest
extends JGroupsCommonTest {
    private JChannel masterChannel;
    private JChannel slaveChannel;

    @Test
    public void testInjectionHappened() throws Exception {
        SearchIntegrator searchFactory = (SearchIntegrator)this.getSearchFactory().unwrap(SearchIntegrator.class);
        MessageSenderService sender = (MessageSenderService)searchFactory.getServiceManager().requestService(MessageSenderService.class);
        Assert.assertTrue((boolean)this.masterChannel.getAddress().equals(sender.getAddress()));
        searchFactory.getServiceManager().releaseService(MessageSenderService.class);
    }

    @Override
    public void setUp() throws Exception {
        this.masterChannel = InjectedChannelTest.createChannel();
        this.slaveChannel = InjectedChannelTest.createChannel();
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            if (this.masterChannel != null) {
                this.masterChannel.close();
            }
            if (this.slaveChannel != null) {
                this.slaveChannel.close();
            }
        }
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.default.worker.backend", "jgroupsMaster");
        cfg.put("hibernate.search.services.jgroups.providedChannel", this.masterChannel);
    }

    @Override
    protected void configureSlave(Map<String, Object> cfg) {
        super.configureSlave(cfg);
        cfg.put("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.put("hibernate.search.services.jgroups.providedChannel", this.slaveChannel);
    }

    private static JChannel createChannel() throws Exception {
        JChannel channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        channel.connect("JGroupsCommonTest" + JGroupsCommonTest.CHANNEL_NAME);
        return channel;
    }
}

