/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Properties;
import org.hibernate.search.backend.jgroups.impl.JGroupsMasterMessageListener;
import org.hibernate.search.backend.jgroups.impl.MessageListenerToRequestHandlerAdapter;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.util.Buffer;
import org.jgroups.util.RspList;

public final class DispatchMessageSender
implements MessageSenderService,
Startable,
Stoppable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String JGROUPS_PREFIX = "hibernate.search.services.jgroups.";
    public static final String CONFIGURATION_FILE = "hibernate.search.services.jgroups.configurationFile";
    public static final String CLUSTER_NAME = "hibernate.search.services.jgroups.clusterName";
    public static final String CHANNEL_INJECT = "hibernate.search.services.jgroups.providedChannel";
    public static final String CLASSLOADER = "hibernate.search.services.jgroups.classloader";
    @Deprecated
    public static final String MUX_ID = "hibernate.search.services.jgroups.mux_id";
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "flush-udp.xml";
    private static final String DEFAULT_CLUSTER_NAME = "Hibernate Search Cluster";
    private ChannelContainer channelContainer;
    private ServiceManager serviceManager;
    private MessageDispatcher dispatcher;

    @Override
    public Address getAddress() {
        return this.channelContainer.getChannel().getAddress();
    }

    @Override
    public View getView() {
        return this.channelContainer.getChannel().getView();
    }

    @Override
    public void send(Buffer data, boolean synchronous, long timeout) throws Exception {
        RequestOptions options = synchronous ? RequestOptions.SYNC() : RequestOptions.ASYNC();
        options.exclusionList(new Address[]{this.dispatcher.getChannel().getAddress()});
        options.setTransientFlags(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
        options.setTimeout(timeout);
        if (synchronous) {
            try {
                RspList rspList = this.dispatcher.castMessage(null, data, options);
                this.handleResponseProblems((RspList<Object>)rspList, null);
            }
            catch (Exception e) {
                throw log.unableToSendWorkViaJGroups(e);
            }
        }
        try {
            this.dispatcher.castMessageWithFuture(null, data, options);
        }
        catch (RuntimeException e) {
            throw log.unableToSendWorkViaJGroups(e);
        }
    }

    private void handleResponseProblems(RspList<Object> response, Throwable e) {
        for (Address suspected : response.getSuspectedMembers()) {
            log.jgroupsSuspectingPeer(suspected);
        }
        if (e != null) {
            throw log.unableToSendWorkViaJGroups(e);
        }
    }

    public void start(Properties props, BuildContext context) {
        log.jGroupsStartingChannelProvider();
        this.serviceManager = context.getServiceManager();
        this.channelContainer = DispatchMessageSender.buildChannel(props);
        this.checkForOldProperties(props);
        NodeSelectorService masterNodeSelector = (NodeSelectorService)this.serviceManager.requestService(NodeSelectorService.class);
        LuceneWorkSerializer luceneWorkSerializer = (LuceneWorkSerializer)this.serviceManager.requestService(LuceneWorkSerializer.class);
        JGroupsMasterMessageListener listener = new JGroupsMasterMessageListener(context, masterNodeSelector, luceneWorkSerializer);
        JChannel channel = this.channelContainer.getChannel();
        MessageListenerToRequestHandlerAdapter requestHandler = new MessageListenerToRequestHandlerAdapter((MessageListener)listener);
        this.dispatcher = new MessageDispatcher(channel, (RequestHandler)requestHandler);
        this.dispatcher.setMembershipListener((MembershipListener)listener);
        this.channelContainer.start();
        masterNodeSelector.setLocalAddress(channel.getAddress());
        if (!channel.flushSupported()) {
            log.jGroupsFlushNotPresentInStack();
        }
        if (log.isDebugEnabled()) {
            log.jgroupsFullConfiguration(channel.getProtocolStack().printProtocolSpecAsXML());
        }
    }

    private void checkForOldProperties(Properties props) {
        if (props.get(MUX_ID) != null) {
            log.muxIdPropertyIsIgnored();
        }
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.pushAll(arg_0 -> ((ServiceManager)this.serviceManager).releaseService(arg_0), (Object[])new Class[]{NodeSelectorService.class, LuceneWorkSerializer.class});
            this.serviceManager = null;
            closer.push(() -> ((MessageDispatcher)this.dispatcher).stop());
            if (this.channelContainer != null) {
                closer.push(this.channelContainer::close);
                this.channelContainer = null;
            }
        }
        catch (RuntimeException toLog) {
            log.jGroupsClosingChannelError(toLog);
        }
    }

    private static ChannelContainer buildChannel(Properties props) {
        String clusterName = ConfigurationParseHelper.getString((Properties)props, (String)CLUSTER_NAME, (String)DEFAULT_CLUSTER_NAME);
        if (props != null) {
            Object channelObject = props.get(CHANNEL_INJECT);
            if (channelObject != null) {
                try {
                    return new InjectedChannelContainer((JChannel)channelObject);
                }
                catch (ClassCastException e) {
                    throw log.jGroupsChannelInjectionError(CHANNEL_INJECT, e, channelObject.getClass());
                }
            }
            String cfg = props.getProperty(CONFIGURATION_FILE);
            if (cfg != null) {
                try {
                    log.startingJGroupsChannel(cfg);
                    return new ManagedChannelContainer(new JChannel(ConfigurationParseHelper.locateConfig((String)cfg)), clusterName);
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationUsingFileError(cfg, e);
                }
            }
        }
        log.jGroupsConfigurationNotFoundInProperties(props);
        try {
            URL fileUrl = ConfigurationParseHelper.locateConfig((String)DEFAULT_JGROUPS_CONFIGURATION_FILE);
            if (fileUrl != null) {
                log.startingJGroupsChannel(fileUrl);
                return new ManagedChannelContainer(new JChannel(fileUrl), clusterName);
            }
            log.jGroupsDefaultConfigurationFileNotFound();
            return new ManagedChannelContainer(new JChannel(), clusterName);
        }
        catch (Exception e) {
            throw log.unableToStartJGroupsChannel(e);
        }
    }

    private static class InjectedChannelContainer
    implements ChannelContainer {
        private final JChannel channel;

        InjectedChannelContainer(JChannel channel) {
            if (channel == null) {
                throw new NullPointerException("channel must not be null");
            }
            this.channel = channel;
        }

        @Override
        public JChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
        }

        @Override
        public void start() {
        }
    }

    private static class ManagedChannelContainer
    implements ChannelContainer {
        private final JChannel channel;
        private final String clusterName;

        ManagedChannelContainer(JChannel channel, String clusterName) {
            if (channel == null) {
                throw new NullPointerException("channel must not be null");
            }
            if (clusterName == null) {
                throw new NullPointerException("clusterName must not be null");
            }
            this.channel = channel;
            this.clusterName = clusterName;
        }

        @Override
        public JChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
            log.jGroupsDisconnectingAndClosingChannel(this.clusterName);
            this.channel.disconnect();
            this.channel.close();
        }

        @Override
        public void start() {
            try {
                this.channel.connect(this.clusterName);
                log.jGroupsConnectedToCluster(this.clusterName, this.channel.getAddress());
            }
            catch (Exception e) {
                throw log.unableConnectingToJGroupsCluster(this.clusterName, e);
            }
        }
    }

    private static interface ChannelContainer {
        public JChannel getChannel();

        public void close();

        public void start();
    }
}

