/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.jgroups.common.DynamicMasterSlaveSearchTestCase;
import org.hibernate.search.test.jgroups.master.TShirt;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.concurrency.Poller;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2675")
public class JGroupsDynamicMasterElectionTest
extends DynamicMasterSlaveSearchTestCase {
    public static final String TESTING_JGROUPS_CONFIGURATION_FILE = "testing-flush-loopback.xml";
    public static final Poller POLLER = Poller.milliseconds((long)10000L, (long)100L);
    private static final int DEFAULT_NUMBER_OF_NODES = 10;
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();
    private final QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);

    @Override
    protected int getExpectedNumberOfNodes() {
        return 10;
    }

    @Test
    public void masterElection() throws Exception {
        TestResourceManager masterResourceManager = (TestResourceManager)this.determineJGroupsMaster().get();
        List<DefaultTestResourceManager> slaveResourceManagers = this.determineJGroupsSlaves();
        Assert.assertEquals((long)(this.getExpectedNumberOfNodes() - 1), (long)slaveResourceManagers.size());
        TShirt ts = new TShirt();
        ts.setLogo("Boston");
        ts.setSize("XXL");
        ts.setLength(23.4);
        this.testAdd(masterResourceManager, slaveResourceManagers, ts, 1);
        masterResourceManager.getSessionFactory().close();
        POLLER.pollAssertion(() -> Assert.assertTrue((String)"Lots of time waited and still no new master has been elected!", (boolean)this.determineJGroupsMaster().isPresent()));
        masterResourceManager = (TestResourceManager)this.determineJGroupsMaster().get();
        slaveResourceManagers = this.determineJGroupsSlaves();
        Assert.assertEquals((long)(this.getExpectedNumberOfNodes() - 2), (long)slaveResourceManagers.size());
        TShirt ts2 = new TShirt();
        ts2.setLogo("Mapple leaves");
        ts2.setSize("L");
        ts2.setLength(23.42);
        this.testAdd(masterResourceManager, slaveResourceManagers, ts2, 2);
    }

    private void testAdd(TestResourceManager masterResourceManager, List<DefaultTestResourceManager> slaveResourceManagers, TShirt ts, int expectedResults) throws ParseException {
        try (Session slaveSession = slaveResourceManagers.get(0).openSession();){
            Transaction tx = slaveSession.beginTransaction();
            slaveSession.persist((Object)ts);
            tx.commit();
            try (Session masterSession = masterResourceManager.openSession();){
                POLLER.pollAssertion(() -> {
                    List<?> result = this.doQuery(masterSession);
                    Assert.assertEquals((String)"Lots of time waited and still the document is not indexed on master yet!", (long)expectedResults, (long)result.size());
                });
            }
        }
        POLLER.pollAssertion(() -> {
            for (TestResourceManager resourceManager : slaveResourceManagers) {
                Session slaveSession = resourceManager.openSession();
                Throwable throwable = null;
                try {
                    List<?> result = this.doQuery(slaveSession);
                    Assert.assertEquals((String)"Lots of time waited and still the document is not visible from the slave yet!", (long)expectedResults, (long)result.size());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (slaveSession == null) continue;
                    if (throwable != null) {
                        try {
                            slaveSession.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    slaveSession.close();
                }
            }
        });
    }

    private List<?> doQuery(Session slaveSession) throws ParseException {
        FullTextSession ftSession = Search.getFullTextSession((Session)slaveSession);
        Query luceneQuery = this.parser.parse("logo:Boston or logo:Mapple leaves");
        slaveSession.getTransaction().begin();
        FullTextQuery query = ftSession.createFullTextQuery(luceneQuery, new Class[0]);
        List result = query.list();
        slaveSession.getTransaction().commit();
        return result;
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.default.retry_initialize_period", "1");
        cfg.put("hibernate.search.default.hibernate.search.services.jgroups.clusterName", CHANNEL_NAME);
        cfg.put("hibernate.search.services.jgroups.configurationFile", TESTING_JGROUPS_CONFIGURATION_FILE);
        cfg.put("hibernate.hbm2ddl.auto", "drop-and-create");
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    private boolean isActive(TestResourceManager manager) {
        return !manager.getSessionFactory().isClosed();
    }

    private boolean isJGroupsMaster(TestResourceManager manager) {
        ExtendedSearchIntegrator integrator = manager.getExtendedSearchIntegrator();
        try (ServiceReference service = integrator.getServiceManager().requestReference(NodeSelectorService.class);){
            NodeSelectorStrategy nodeSelector = ((NodeSelectorService)service.get()).getMasterNodeSelector(TShirt.INDEX_NAME);
            boolean bl = nodeSelector.isIndexOwnerLocal();
            return bl;
        }
    }

    private Optional<DefaultTestResourceManager> determineJGroupsMaster() {
        return this.getResourceManagers().stream().filter(this::isActive).filter(this::isJGroupsMaster).findFirst();
    }

    private List<DefaultTestResourceManager> determineJGroupsSlaves() {
        return this.getResourceManagers().stream().filter(this::isActive).filter(manager -> !this.isJGroupsMaster((TestResourceManager)manager)).collect(Collectors.toList());
    }
}

