/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backends.jgroups;

import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JGroupsConfigurationTest {
    @Rule
    public ExpectedException error = ExpectedException.none();

    @Test
    public void refuseConfigurationFileOnDefaultIndex() throws Throwable {
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.worker.backend", "jgroupsMaster").addProperty("hibernate.search.default.worker.backend.jgroups.configurationFile", "some non existing file");
        this.error.expect(SearchException.class);
        this.error.expectMessage("JGroups channel configuration should be specified in the global section");
        JGroupsConfigurationTest.bootConfiguration(cfg);
    }

    @Test
    public void refuseConfigurationFileOnSpecificIndex() throws Throwable {
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.dvds.worker.backend", "jgroupsMaster").addProperty("hibernate.search.dvds.worker.backend.jgroups.configurationFile", "some non existing file");
        this.error.expect(SearchException.class);
        this.error.expectMessage("JGroups channel configuration should be specified in the global section");
        JGroupsConfigurationTest.bootConfiguration(cfg);
    }

    @Test
    public void acceptConfigurationFile() throws Throwable {
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.dvds.worker.backend", "jgroupsMaster").addProperty("hibernate.search.services.jgroups.configurationFile", "some non existing file");
        this.error.expect(SearchException.class);
        this.error.expectMessage("Error while trying to create a channel using config file: some non existing file");
        JGroupsConfigurationTest.bootConfiguration(cfg);
    }

    private static void bootConfiguration(ManualConfiguration cfg) throws Throwable {
        cfg.addClass(Dvd.class);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        SearchFactoryImplementor buildSearchFactory = null;
        try {
            buildSearchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        }
        catch (SearchException se) {
            throw se.getCause();
        }
        finally {
            if (buildSearchFactory != null) {
                buildSearchFactory.close();
            }
        }
    }

    @Indexed(index="dvds")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

