/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import junit.framework.Assert;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.Test;

public class IndexMetadataCompleteConfiguredTest {
    @Test
    public void testDefaultImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        this.verifyIndexCompleteMetadataOption(true, cfg);
    }

    @Test
    public void testIndexMetadataCompleteFalse() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setIndexMetadataComplete(false);
        this.verifyIndexCompleteMetadataOption(false, cfg);
    }

    @Test
    public void testIndexMetadataCompleteTrue() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setIndexMetadataComplete(true);
        this.verifyIndexCompleteMetadataOption(true, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndexCompleteMetadataOption(boolean expectation, ManualConfiguration cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().indexName("index1").property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        cfg.addClass(Document.class);
        MutableSearchFactory sf = (MutableSearchFactory)new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        try {
            Assert.assertEquals((boolean)expectation, (boolean)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Document.class).areSingleTermDeletesSafe());
            sf.addClasses(new Class[]{Dvd.class, Book.class});
            Assert.assertEquals((boolean)false, (boolean)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Dvd.class).areSingleTermDeletesSafe());
            Assert.assertEquals((boolean)false, (boolean)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Document.class).areSingleTermDeletesSafe());
            Assert.assertEquals((boolean)expectation, (boolean)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Book.class).areSingleTermDeletesSafe());
        }
        finally {
            sf.close();
        }
    }

    private static AbstractWorkspaceImpl extractWorkspace(MutableSearchFactory sf, Class<?> type) {
        EntityIndexBinding indexBindingForEntity = sf.getIndexBinding(type);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagers()[0];
        LuceneBackendQueueProcessor backend = (LuceneBackendQueueProcessor)indexManager.getBackendQueueProcessor();
        return backend.getIndexResources().getWorkspace();
    }

    @Indexed(index="index2")
    public static final class Book {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="index1")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }

    public static final class Document {
        long id;
        String title;
    }
}

