/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileHelperTest {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private static File root;
    private String srcDir = "filehelpersrc";
    private String destDir = "filehelperdest";

    @BeforeClass
    public static void prepareRootDirectory() {
        String buildDir = System.getProperty("build.dir");
        if (buildDir == null) {
            buildDir = ".";
        }
        root = new File(buildDir, "filehelper");
        log.infof("Using %s as test directory.", (Object)root.getAbsolutePath());
    }

    private File createFile(File dir, String name) throws IOException {
        File file = new File(dir, name);
        file.createNewFile();
        this.writeDummyDataToFile(file);
        return file;
    }

    private void writeDummyDataToFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file, true);
        os.write(1);
        os.write(2);
        os.write(3);
        os.flush();
        os.close();
    }

    @After
    public void tearDown() throws Exception {
        File dir = new File(root, this.srcDir);
        FileHelper.delete((File)dir);
        dir = new File(root, this.destDir);
        FileHelper.delete((File)dir);
        FileHelper.delete((File)root);
    }

    @Test
    public void testSynchronize() throws Exception {
        File src = new File(root, this.srcDir);
        src.mkdirs();
        String name = "a";
        this.createFile(src, name);
        name = "b";
        this.createFile(src, name);
        File subDir = new File(src, "subdir");
        subDir.mkdirs();
        name = "c";
        this.createFile(subDir, name);
        File dest = new File(root, this.destDir);
        Assert.assertFalse((String)"Directories should be out of sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        FileHelper.synchronize((File)src, (File)dest, (boolean)true);
        Assert.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        File destTestFile1 = new File(dest, "b");
        Assert.assertTrue((boolean)destTestFile1.exists());
        File destTestFile2 = new File(new File(dest, "subdir"), "c");
        Assert.assertTrue((boolean)destTestFile2.exists());
        File destTestFile3 = this.createFile(dest, "foo");
        File srcTestFile = new File(src, "c");
        this.writeDummyDataToFile(srcTestFile);
        File destTestFile = new File(dest, "c");
        Assert.assertNotSame((Object)srcTestFile.lastModified(), (Object)destTestFile.lastModified());
        Assert.assertFalse((String)"Directories should be out of sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        FileHelper.synchronize((File)src, (File)dest, (boolean)true);
        Assert.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        Assert.assertEquals((long)srcTestFile.lastModified(), (long)destTestFile.lastModified());
        Assert.assertEquals((long)srcTestFile.length(), (long)destTestFile.length());
        Assert.assertTrue((boolean)destTestFile1.exists());
        Assert.assertTrue((boolean)destTestFile2.exists());
        Assert.assertTrue((!destTestFile3.exists() ? 1 : 0) != 0);
        srcTestFile.delete();
        FileHelper.synchronize((File)src, (File)dest, (boolean)true);
        Assert.assertTrue((!destTestFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
    }
}

