/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.textbuilder;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.Set;

public class WordDictionary {
    private static final Random r = new Random(12L);
    private final String[] positionalWords;
    private final int maxSize;
    private final double gaussFactor;

    public WordDictionary(Set<String> words) {
        this.positionalWords = words.toArray(new String[0]);
        Arrays.sort(this.positionalWords, new StringLengthComparator());
        this.maxSize = this.positionalWords.length;
        this.gaussFactor = ((double)this.maxSize + 1.0) / 4.0;
    }

    public String randomWord() {
        int position = Math.abs((int)(r.nextGaussian() * this.gaussFactor));
        if (position < this.maxSize) {
            return this.positionalWords[position];
        }
        return this.randomWord();
    }

    private static class StringLengthComparator
    implements Comparator<String>,
    Serializable {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    }
}

