/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeMetadataTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        ConfigContext configContext = new ConfigContext((SearchConfiguration)new ManualConfiguration());
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testMultipleDocumentIdsCauseException() {
        try {
            this.metadataProvider.getTypeMetadataFor(Foo.class);
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000167: More than one @DocumentId specified on entity 'org.hibernate.search.test.configuration.TypeMetadataTest$Foo'", (Object)e.getMessage());
        }
    }

    @Indexed
    public class Foo {
        @DocumentId
        private Integer id;
        @DocumentId
        private String name;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

