/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import java.util.Properties;
import junit.framework.Assert;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.impl.TransactionalWorker;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.Before;
import org.junit.Test;

public class WorkerScopeConfigurationTest {
    private ManualConfiguration manualConfiguration;

    @Before
    public void setUp() {
        this.manualConfiguration = new ManualConfiguration();
        SearchMapping searchMapping = new SearchMapping();
        searchMapping.entity(Document.class).indexed().property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        this.manualConfiguration.setProgrammaticMapping(searchMapping);
        this.manualConfiguration.addProperty("hibernate.search.default.directory_provider", "ram");
        this.manualConfiguration.addClass(Document.class);
    }

    @Test
    public void testDefaultWorker() {
        SearchFactoryImplementor searchFactoryImplementor = new SearchFactoryBuilder().configuration((SearchConfiguration)this.manualConfiguration).buildSearchFactory();
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchFactoryImplementor.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchFactoryImplementor.getWorker() instanceof TransactionalWorker));
    }

    @Test
    public void testExplicitTransactionalWorker() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", "transaction");
        SearchFactoryImplementor searchFactoryImplementor = new SearchFactoryBuilder().configuration((SearchConfiguration)this.manualConfiguration).buildSearchFactory();
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchFactoryImplementor.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchFactoryImplementor.getWorker() instanceof TransactionalWorker));
    }

    @Test
    public void testCustomWorker() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", CustomWorker.class.getName());
        SearchFactoryImplementor searchFactoryImplementor = new SearchFactoryBuilder().configuration((SearchConfiguration)this.manualConfiguration).buildSearchFactory();
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchFactoryImplementor.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchFactoryImplementor.getWorker() instanceof CustomWorker));
    }

    @Test
    public void testCustomWorkerWithProperties() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", CustomWorkerExpectingFooAndBar.class.getName());
        this.manualConfiguration.addProperty("hibernate.search.worker.foo", "foo");
        this.manualConfiguration.addProperty("hibernate.search.worker.bar", "bar");
        SearchFactoryImplementor searchFactoryImplementor = new SearchFactoryBuilder().configuration((SearchConfiguration)this.manualConfiguration).buildSearchFactory();
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchFactoryImplementor.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchFactoryImplementor.getWorker() instanceof CustomWorkerExpectingFooAndBar));
    }

    @Test
    public void testUnknownWorkerImplementationClass() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", "foo");
        try {
            new SearchFactoryBuilder().configuration((SearchConfiguration)this.manualConfiguration).buildSearchFactory();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Unexpected error message", (boolean)e.getMessage().contains("Unable to find worker implementation class: foo"));
        }
    }

    public static final class CustomWorkerExpectingFooAndBar
    implements Worker {
        public static final String FOO = "hibernate.search.worker.foo";
        public static final String BAR = "hibernate.search.worker.bar";

        public void performWork(Work<?> work, TransactionContext transactionContext) {
        }

        public void initialize(Properties props, WorkerBuildContext context, QueueingProcessor queueingProcessor) {
            Assert.assertTrue((String)"Missing property: hibernate.search.worker.foo", (boolean)props.containsKey(FOO));
            Assert.assertTrue((String)"Missing property: hibernate.search.worker.bar", (boolean)props.containsKey(BAR));
        }

        public void close() {
        }

        public void flushWorks(TransactionContext transactionContext) {
        }
    }

    public static final class CustomWorker
    implements Worker {
        public void performWork(Work<?> work, TransactionContext transactionContext) {
        }

        public void initialize(Properties props, WorkerBuildContext context, QueueingProcessor queueingProcessor) {
        }

        public void close() {
        }

        public void flushWorks(TransactionContext transactionContext) {
        }
    }

    public static final class Document {
        private long id;
        private String title;
    }
}

