/*
 * Decompiled with CFR 0.152.
 */
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2909")
public class NoPackageAnnotationTest {
    private static final IndexedTypeIdentifier TYPE_ID = PojoIndexedTypeIdentifier.convertFromLegacy(Entity.class);
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void initializationSucceedsWithNotPackagedAnnotation() throws Exception {
        SearchConfigurationForTest config = new SearchConfigurationForTest().addClasses(Entity.class, ClassWithNotPackagedAnnotation.class);
        ExtendedSearchIntegrator integrator = this.integratorResource.create(config);
        Assert.assertNotNull((Object)integrator.getIndexedTypeDescriptor(TYPE_ID));
    }

    @NotPackagedAnnotation
    private static class ClassWithNotPackagedAnnotation {
        private ClassWithNotPackagedAnnotation() {
        }
    }

    @Indexed
    private static class Entity {
        @DocumentId
        Integer id;
        @Field
        String title;

        private Entity() {
        }
    }
}

