/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import java.util.Properties;
import org.easymock.EasyMock;
import org.hibernate.search.backend.impl.LocalBackend;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackend;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.junit.Test;

public class BackendQueueProcessorTest {
    @Test
    public void testCheckingForNullWork() {
        this.checkBackendBehaviour((Backend)LocalBackend.INSTANCE);
        this.checkBackendBehaviour((Backend)BlackHoleBackend.INSTANCE);
    }

    private void checkBackendBehaviour(Backend backend) {
        try {
            WorkerBuildContext context = (WorkerBuildContext)EasyMock.createNiceMock(WorkerBuildContext.class);
            IndexManager indexManager = (IndexManager)EasyMock.createNiceMock(IndexManager.class);
            backend.initialize(new Properties(), context);
            BackendQueueProcessor processor = backend.createQueueProcessor(indexManager, context);
            processor.applyWork(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

