/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.builtin;

import java.net.URI;
import java.sql.Blob;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.TikaBridge;

@Indexed
class Book {
    private Integer id;
    private Blob contentAsBlob;
    private byte[] contentAsBytes;
    private URI contentAsURI;
    private Set<String> contentAsListOfString;

    public Book(int id, String ... contents) {
        this(id);
        HashSet<String> temp = new HashSet<String>();
        for (String string : contents) {
            temp.add(string);
        }
        this.contentAsListOfString = temp;
    }

    public Book(int id, Blob content) {
        this(id);
        this.contentAsBlob = content;
    }

    public Book(int id, byte[] content) {
        this(id);
        this.contentAsBytes = content;
    }

    public Book(int id, URI content) {
        this(id);
        this.contentAsURI = content;
    }

    public Book(int id) {
        this.id = id;
    }

    @DocumentId
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Field(indexNullAs="<NULL>")
    @TikaBridge
    public Blob getContentAsBlob() {
        return this.contentAsBlob;
    }

    public void setContentAsBlob(Blob contentAsBlob) {
        this.contentAsBlob = contentAsBlob;
    }

    @Field(indexNullAs="<NULL>")
    @TikaBridge
    public byte[] getContentAsBytes() {
        return this.contentAsBytes;
    }

    public void setContentAsBytes(byte[] contentAsBytes) {
        this.contentAsBytes = contentAsBytes;
    }

    @Field(indexNullAs="<NULL>")
    @TikaBridge
    public URI getContentAsURI() {
        return this.contentAsURI;
    }

    public void setContentAsURI(URI contentAsURI) {
        this.contentAsURI = contentAsURI;
    }

    @IndexedEmbedded
    @Field
    @TikaBridge
    public Set<String> getContentAsListOfString() {
        return this.contentAsListOfString;
    }

    public void setContentAsListOfString(Set<String> contentAsListOfString) {
        this.contentAsListOfString = contentAsListOfString;
    }
}

