/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl.embedded;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.dsl.embedded.ContainerEntity;
import org.hibernate.search.test.dsl.embedded.EmbeddedEntity;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DslEmbeddedSearchTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(ContainerEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    private static Calendar initCalendar(int year, int month, int day) {
        Calendar instance = DslEmbeddedSearchTest.createCalendar();
        instance = DateUtils.truncate((Calendar)instance, (int)5);
        instance.set(year, month, day);
        return instance;
    }

    private static Calendar createCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ITALY);
    }

    @Before
    public void setUp() throws Exception {
        EmbeddedEntity ee = new EmbeddedEntity();
        ee.setEmbeddedField("embedded");
        ee.setNumber(7);
        ee.setDate(DslEmbeddedSearchTest.initCalendar(2007, 0, 14).getTime());
        ContainerEntity pe = new ContainerEntity();
        pe.setId(1L);
        pe.setEmbeddedEntity(ee);
        pe.setParentStringValue("theparentvalue");
        this.helper.add(pe);
        EmbeddedEntity ee2 = new EmbeddedEntity();
        ee2.setEmbeddedField("otherembedded");
        ee2.setNumber(3);
        ee2.setDate(DslEmbeddedSearchTest.initCalendar(2007, 0, 12).getTime());
        ContainerEntity pe2 = new ContainerEntity();
        pe2.setId(2L);
        pe2.setEmbeddedEntity(ee2);
        pe2.setParentStringValue("theotherparentvalue");
        this.helper.add(pe2);
    }

    @Test
    public void testSearchString() throws Exception {
        QueryBuilder qb = this.helper.queryBuilder(ContainerEntity.class);
        Query q = qb.keyword().onField("emb.embeddedField").matching((Object)"embedded").createQuery();
        this.assertQuery(q).matchesExactlyIds(Long.valueOf(1L));
    }

    @Test
    public void testSearchNumberWithFieldBridge() throws Exception {
        QueryBuilder qb = this.helper.queryBuilder(ContainerEntity.class);
        Query q = qb.keyword().onField("emb.num").matching((Object)7).createQuery();
        this.assertQuery(q).matchesExactlyIds(Long.valueOf(1L));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2070")
    public void testSearchDateWithoutFieldBridge() throws Exception {
        QueryBuilder qb = this.helper.queryBuilder(ContainerEntity.class);
        Query q = qb.range().onField("emb.date").above((Object)DslEmbeddedSearchTest.initCalendar(2007, 0, 14).getTime()).createQuery();
        this.assertQuery(q).matchesExactlyIds(Long.valueOf(1L));
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertQuery(Query q) {
        return this.helper.assertThat(q).from(ContainerEntity.class);
    }
}

