/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.common;

import java.lang.annotation.ElementType;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.de.GermanStemFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.analyzer.common.BlogEntry;
import org.hibernate.search.test.analyzer.common.Entity1;
import org.hibernate.search.test.analyzer.common.Entity2;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DuplicatedAnalyzerDefinitionTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void testDuplicatedAnalyzerDefinitionThrowsException() throws Exception {
        SearchConfigurationForTest config = new SearchConfigurationForTest().addClasses(Entity1.class, Entity2.class).addProperty("hibernate.search.default.directory_provider", "local-heap");
        try {
            this.integratorResource.create(config);
            Assert.fail((String)"Integrator creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000330: Multiple analyzer definitions with the same name: 'my-analyzer'.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDuplicatedProgrammaticAnalyzerDefinitionThrowsException() throws Exception {
        SearchConfigurationForTest config = new SearchConfigurationForTest().addProperty("hibernate.search.model_mapping", ProgrammaticMappingWithDuplicateAnalyzerDefinitions.class.getName()).addProperty("hibernate.search.default.directory_provider", "local-heap");
        try {
            this.integratorResource.create(config);
            Assert.fail((String)"Integrator creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000330: Multiple analyzer definitions with the same name: 'english'.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDuplicatedAnalyzerDiscriminatorDefinitions() throws Exception {
        SearchConfigurationForTest config = new SearchConfigurationForTest().addClass(BlogEntry.class).addProperty("hibernate.search.default.directory_provider", "local-heap");
        try {
            this.integratorResource.create(config);
            Assert.fail((String)"Integrator creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Wrong error message", (boolean)e.getMessage().startsWith("Multiple AnalyzerDiscriminator defined in the same class hierarchy"));
        }
    }

    public static class ProgrammaticMappingWithDuplicateAnalyzerDefinitions {
        @Factory
        public SearchMapping create() {
            SearchMapping searchMapping = new SearchMapping();
            searchMapping.analyzerDef("english", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(SnowballPorterFilterFactory.class).analyzerDef("english", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(GermanStemFilterFactory.class).entity(BlogEntry.class).indexed().property("title", ElementType.METHOD);
            return searchMapping;
        }
    }
}

