/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.LocalDateTimeBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LocalDateTimeBridgeTest {
    private static final LocalDateTimeBridge BRIDGE = LocalDateTimeBridge.INSTANCE;
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalDateTime.MAX)).isEqualTo((Object)"+9999999991231235959999999999");
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalDateTime.MIN)).isEqualTo((Object)"-9999999990101000000000000000");
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        LocalDate date = LocalDate.of(1, 2, 3);
        LocalTime time = LocalTime.of(4, 5, 6, 7);
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalDateTime.of(date, time))).isEqualTo((Object)"+0000000010203040506000000007");
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject("+9999999991231235959999999999")).isEqualTo((Object)LocalDateTime.MAX);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject("-9999999990101000000000000000")).isEqualTo((Object)LocalDateTime.MIN);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        LocalDate date = LocalDate.of(1, 2, 3);
        LocalTime time = LocalTime.of(4, 5, 6, 7);
        Assertions.assertThat((Object)BRIDGE.stringToObject("+0000000010203040506000000007")).isEqualTo((Object)LocalDateTime.of(date, time));
    }
}

