/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalTime;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.LocalTimeBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LocalTimeBridgeTest {
    private static final LocalTimeBridge BRIDGE = LocalTimeBridge.INSTANCE;
    private static final String MAX = "235959999999999";
    private static final String MIN = "000000000000000";
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalTime.MAX)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalTime.MIN)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalTime.of(4, 5, 6, 7))).isEqualTo((Object)"040506000000007");
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)LocalTime.MAX);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)LocalTime.MIN);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject("040506000000007")).isEqualTo((Object)LocalTime.of(4, 5, 6, 7));
    }
}

