/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.numeric;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.test.engine.numeric.TouristAttraction;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class LuceneNumericFieldTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(TouristAttraction.class, ScoreBoard.class, Score.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void setUp() throws Exception {
        this.prepareData();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testOneOfSeveralFieldsIsNumeric() {
        List list = this.helper.hsQuery(TouristAttraction.class).projection(new String[]{"__HSearch_Document"}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)list.size());
        Document document = (Document)((EntityInfo)list.iterator().next()).getProjection()[0];
        IndexableField scoreNumeric = document.getField("scoreNumeric");
        Assertions.assertThat((Object)scoreNumeric.numericValue()).isEqualTo((Object)23);
        IndexableField scoreString = document.getField("scoreString");
        Assertions.assertThat((Object)scoreString.numericValue()).isNull();
        Assertions.assertThat((String)scoreString.stringValue()).isEqualTo((Object)"23");
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testNumericMappingOfEmbeddedFields() {
        List list = this.helper.hsQuery(ScoreBoard.class).projection(new String[]{"__HSearch_Document"}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)list.size());
        Document document = (Document)((EntityInfo)list.iterator().next()).getProjection()[0];
        IndexableField scoreNumeric = document.getField("score_id");
        Assertions.assertThat((Object)scoreNumeric.numericValue()).isEqualTo((Object)1);
        IndexableField beta = document.getField("score_beta");
        Assertions.assertThat((Object)beta.numericValue()).isEqualTo((Object)100);
    }

    private void prepareData() {
        TouristAttraction attraction = new TouristAttraction(1, 23, 46);
        this.helper.add(attraction);
        Score score1 = new Score();
        score1.id = 1;
        score1.subscore = 100;
        this.helper.add(score1);
        ScoreBoard scoreboard = new ScoreBoard();
        scoreboard.id = 1L;
        scoreboard.scores.add(score1);
        this.helper.add(scoreboard);
    }

    @Indexed
    private static class Score {
        @DocumentId
        @NumericField
        Integer id;
        @Field(name="beta", store=Store.YES)
        Integer subscore;

        private Score() {
        }
    }

    @Indexed
    private static class ScoreBoard {
        @DocumentId
        Long id;
        @IndexedEmbedded(includeEmbeddedObjectId=true, prefix="score_")
        Set<Score> scores = new HashSet<Score>();

        private ScoreBoard() {
        }
    }
}

