/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.numeric;

import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;

public class NumericDocumentIdIndexedEmbeddedTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    private SearchIntegrator integrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.integrator);

    @TestForIssue(jiraKey="HSEARCH-2545")
    @Test
    public void testIndexAndSearchNumericField() {
        this.integrator = this.integratorResource.create(new SearchConfigurationForTest().addClasses(A.class, B.class, C.class));
        A a = new A();
        a.id = 0L;
        B b = new B();
        b.id = 1L;
        b.a = a;
        C c = new C();
        c.id = 2L;
        c.b = b;
        this.helper.add(a, c);
        this.assertRangeQuery(C.class, "b.a.id", a.id, a.id).as("Query id ").hasResultSize(1);
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertRangeQuery(Class<?> entityClass, String fieldName, Object from, Object to) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)true, (boolean)true);
        return this.helper.assertThat(query).from(entityClass);
    }

    @Indexed
    private static class C {
        @DocumentId
        private Long id;
        @IndexedEmbedded(includePaths={"a.id"})
        private B b;

        private C() {
        }
    }

    private static class B {
        @DocumentId
        private Long id;
        @IndexedEmbedded(includePaths={"id"})
        private A a;

        private B() {
        }
    }

    @Indexed
    private static class A {
        @DocumentId
        @NumericField
        @SortableField
        private Long id;

        private A() {
        }
    }
}

