/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.numeric;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.ShortBridge;
import org.hibernate.search.bridge.util.impl.BridgeAdaptor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.FieldSettingsDescriptor;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.engine.numeric.Coordinate;
import org.hibernate.search.test.engine.numeric.Country;
import org.hibernate.search.test.engine.numeric.Location;
import org.hibernate.search.test.engine.numeric.PinPoint;
import org.hibernate.search.test.engine.numeric.PointOfInterest;
import org.hibernate.search.test.engine.numeric.Position;
import org.hibernate.search.test.engine.numeric.TouristAttraction;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class NumericFieldTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(PinPoint.class, Location.class, Coordinate.class, PointOfInterest.class, Position.class, TouristAttraction.class, ScoreBoard.class, Score.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void setUp() throws Exception {
        this.prepareData();
    }

    @Test
    public void testIndexAndSearchNumericField() {
        this.assertRangeQuery("overriddenFieldName", 1, 3).as("Query id ").hasResultSize(3);
        this.assertRangeQuery("latitude", -10.0, 10.0).as("Query by double range").hasResultSize(3);
        this.assertRangeQuery("importance", (short)11, (short)13).as("Query by short range").hasResultSize(3);
        this.assertRangeQuery("fallbackImportance", Short.valueOf("11"), Short.valueOf("13")).as("Query by Short range").hasResultSize(3);
        this.assertRangeQuery("popularity", (byte)21, (byte)23).as("Query by byte range").hasResultSize(3);
        this.assertRangeQuery("fallbackPopularity", Byte.valueOf("21"), Byte.valueOf("23")).as("Query by Byte range").hasResultSize(3);
        this.assertRangeQuery("ranking", 1, 2).as("Query by integer range").hasResultSize(4);
        this.assertRangeQuery("myCounter", 1L, 3L).as("Query by long range").hasResultSize(3);
        this.assertRangeQuery("strMultiple", 0.7, 0.9).as("Query by multi-fields").hasResultSize(2);
        this.assertRangeQuery("visibleStars", -100L, 500L).as("Query on custom bridge by range").hasResultSize(4);
        this.assertRangeQuery("overriddenFieldName", 1, 3, true, false).as("Query by id excluding upper").hasResultSize(2);
        this.assertRangeQuery("overriddenFieldName", 1, 3, false, false).as("Query by id excluding upper and lower").hasResultSize(1);
        this.assertRangeQuery("country.idh", 0.9, 1.0).as("Range Query for indexed embedded").hasResultSize(2);
        this.assertRangeQuery("pinPoints.stars", 4, 5).as("Range Query across entities").hasResultSize(1);
        this.assertExactQuery("overriddenFieldName", 1).as("Query id exact").matchesExactlyIds(Integer.valueOf(1));
        this.assertExactQuery("latitude", -10.0).as("Query double exact").matchesExactlyIds(Integer.valueOf(2));
        this.assertExactQuery("importance", 12).as("Query short exact").matchesExactlyIds(Integer.valueOf(3));
        this.assertExactQuery("popularity", 22).as("Query byte exact").matchesExactlyIds(Integer.valueOf(3));
        this.assertExactQuery("longitude", -20.0).as("Query integer exact").matchesExactlyIds(Integer.valueOf(3));
        this.assertExactQuery("myCounter", 4L).as("Query long exact").matchesExactlyIds(Integer.valueOf(4));
        this.assertExactQuery("strMultiple", 0.1).as("Query multifield exact").matchesExactlyIds(Integer.valueOf(5));
        this.assertExactQuery("visibleStars", 1000L).as("Query on custom bridge exact").matchesExactlyIds(Integer.valueOf(3));
        this.helper.delete(Location.class, Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));
        this.assertRangeQuery("overriddenFieldName", 1, 6).as("Check for deletion on Query").hasResultSize(0);
        this.assertRangeQuery("overriddenFieldName", 1, 6).projecting("__HSearch_id").as("Check for deletion on index projection").hasResultSize(0);
    }

    @TestForIssue(jiraKey="HSEARCH-1193")
    @Test
    public void testNumericFieldProjections() {
        Query latitudeQuery = NumericFieldUtils.createNumericRangeQuery((String)"latitude", (Object)-20.0, (Object)-20.0, (boolean)true, (boolean)true);
        this.helper.assertThat(latitudeQuery).from(Location.class).projecting("latitude").matchesExactlySingleProjections(-20.0);
        this.helper.assertThat(latitudeQuery).from(Location.class).projecting("coordinatePair_x", "coordinatePair_y", "importance", "popularity").matchesExactlyProjections(new Object[][]{{1.0, 2.0, (short)10, (byte)20}});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-997")
    public void testShortDocumentIdExplicitlyMappedAsNumericField() {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)"myId", (Object)1, (Object)1, (boolean)true, (boolean)true);
        this.helper.assertThat(query).from(Coordinate.class).matchesExactlyIds(Short.valueOf((short)1));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-997")
    public void testByteDocumentIdExplicitlyMappedAsNumericField() {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)"myId", (Object)1, (Object)1, (boolean)true, (boolean)true);
        this.helper.assertThat(query).from(PointOfInterest.class).matchesExactlyIds(Byte.valueOf((byte)1));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-997")
    public void testByteDocumentIdMappedAsStringFieldByDefault() {
        TermRangeQuery query = TermRangeQuery.newStringRange((String)"id", (String)"1", (String)"1", (boolean)true, (boolean)true);
        this.helper.assertThat((Query)query).from(Position.class).matchesExactlyIds(Byte.valueOf((byte)1));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testOneOfSeveralFieldsIsNumeric() {
        Assert.assertEquals((Object)NumericFieldBridge.SHORT_FIELD_BRIDGE, (Object)this.getUnwrappedBridge(TouristAttraction.class, "scoreNumeric", NumericFieldBridge.class));
        Assert.assertNotNull((Object)this.getUnwrappedBridge(TouristAttraction.class, "scoreString", ShortBridge.class));
    }

    private Object getUnwrappedBridge(Class<?> clazz, String string, Class<?> expectedBridgeClass) {
        FieldBridge bridge = ((EntityIndexBinding)this.sfHolder.getSearchFactory().getIndexBindings().get(clazz)).getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(string).getFieldBridge();
        return this.unwrapBridge(bridge, expectedBridgeClass);
    }

    private Object unwrapBridge(Object bridge, Class<?> expectedBridgeClass) {
        if (bridge instanceof BridgeAdaptor) {
            return ((BridgeAdaptor)bridge).unwrap(expectedBridgeClass);
        }
        return bridge;
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testSomeOfSeveralFieldsAreNumeric() {
        Set fields = this.sfHolder.getSearchFactory().getIndexedTypeDescriptor((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(TouristAttraction.class)).getProperty("rating").getIndexedFields();
        Assertions.assertThat((Iterable)fields).extracting("name").containsOnly(new Object[]{"rating", "ratingNumericPrecision1", "ratingNumericPrecision2"});
        for (FieldDescriptor field : fields) {
            if ("ratingNumericPrecision1".equals(field.getName())) {
                Assertions.assertThat((Comparable)field.getType()).isEqualTo((Object)FieldSettingsDescriptor.Type.NUMERIC);
                Assertions.assertThat((int)((NumericFieldSettingsDescriptor)field.as(NumericFieldSettingsDescriptor.class)).precisionStep()).isEqualTo(1);
                continue;
            }
            if ("ratingNumericPrecision2".equals(field.getName())) {
                Assertions.assertThat((Comparable)field.getType()).isEqualTo((Object)FieldSettingsDescriptor.Type.NUMERIC);
                Assertions.assertThat((int)((NumericFieldSettingsDescriptor)field.as(NumericFieldSettingsDescriptor.class)).precisionStep()).isEqualTo(2);
                continue;
            }
            Assertions.assertThat((Comparable)field.getType()).isEqualTo((Object)FieldSettingsDescriptor.Type.BASIC);
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testNumericMappingOfEmbeddedFields() {
        Assert.assertEquals((Object)NumericFieldBridge.INT_FIELD_BRIDGE, (Object)this.getUnwrappedBridge(ScoreBoard.class, "score_id", NumericFieldBridge.class));
        Assert.assertEquals((Object)NumericFieldBridge.INT_FIELD_BRIDGE, (Object)this.getUnwrappedBridge(ScoreBoard.class, "score_beta", NumericFieldBridge.class));
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertExactQuery(String fieldName, Object value) {
        Query matchQuery = NumericFieldUtils.createExactMatchQuery((String)fieldName, (Object)value);
        return this.helper.assertThat(matchQuery).from(Location.class);
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertRangeQuery(String fieldName, Object from, Object to) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)true, (boolean)true);
        return this.helper.assertThat(query).from(Location.class);
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertRangeQuery(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)includeLower, (boolean)includeUpper);
        return this.helper.assertThat(query).from(Location.class);
    }

    private void prepareData() {
        Location loc1 = new Location(1, 1L, -20.0, -40.0, 1, "Random text", 1.5, this.countryFor("England", 0.947), BigDecimal.ONE, 10, 20);
        loc1.addPinPoints(new PinPoint(1, 4, loc1), new PinPoint(2, 5, loc1));
        Location loc2 = new Location(2, 2L, -10.0, -30.0, 1, "Some text", 0.786, this.countryFor("Italy", 0.951), BigDecimal.ONE, 11, 21);
        loc2.addPinPoints(new PinPoint(3, 1, loc2), new PinPoint(4, 2, loc2));
        Location loc3 = new Location(3, 3L, 0.0, -20.0, 1, "A text", 0.86, this.countryFor("Brazil", 0.813), BigDecimal.TEN, 12, 22);
        Location loc4 = new Location(4, 4L, 10.0, 0.0, 2, "Any text", 0.99, this.countryFor("France", 0.872), BigDecimal.ONE, 13, 23);
        Location loc5 = new Location(5, 5L, 20.0, 20.0, 3, "Random text", 0.1, this.countryFor("India", 0.612), BigDecimal.ONE, 14, 24);
        this.helper.add(loc1, loc2, loc3, loc4, loc5);
        Coordinate coordinate1 = new Coordinate(1, -20.0, 20.0);
        Coordinate coordinate2 = new Coordinate(2, -30.0, 30.0);
        this.helper.add(coordinate1, coordinate2);
        PointOfInterest poi1 = new PointOfInterest(1, -20.0, 20.0);
        PointOfInterest poi2 = new PointOfInterest(2, -30.0, 30.0);
        this.helper.add(poi1, poi2);
        Position position1 = new Position(1, -20.0, 20.0);
        Position position2 = new Position(2, -30.0, 30.0);
        this.helper.add(position1, position2);
        TouristAttraction attraction = new TouristAttraction(1, 23, 46);
        this.helper.add(attraction);
        Score score1 = new Score();
        score1.id = 1;
        score1.subscore = 100;
        this.helper.add(score1);
        ScoreBoard scoreboard = new ScoreBoard();
        scoreboard.id = 1L;
        scoreboard.scores.add(score1);
        this.helper.add(scoreboard);
    }

    private Country countryFor(String name, double idh) {
        return new Country(name, idh);
    }

    @Indexed
    private static class Score {
        @DocumentId
        @NumericField
        Integer id;
        @Field(name="beta", store=Store.YES)
        Integer subscore;

        private Score() {
        }
    }

    @Indexed
    private static class ScoreBoard {
        @DocumentId
        Long id;
        @IndexedEmbedded(includeEmbeddedObjectId=true, prefix="score_")
        Set<Score> scores = new HashSet<Score>();

        private ScoreBoard() {
        }
    }
}

