/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.lang.reflect.Field;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.builtin.DefaultStringBridge;
import org.hibernate.search.bridge.util.impl.String2FieldBridgeAdaptor;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.metadata.DescriptorTestHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1756")
public class DefaultStringBridgeTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testUsageOfDefaultStringBridgeInFieldBridgeAnnotation() throws Exception {
        String fieldName = "foo";
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Foo.class, fieldName);
        org.hibernate.search.bridge.FieldBridge fieldBridge = fieldDescriptor.getFieldBridge();
        Assert.assertTrue((String)"The DefaultStringBridge should be wrapped in String2FieldBridgeAdaptor", (boolean)(fieldBridge instanceof String2FieldBridgeAdaptor));
        Field field = fieldBridge.getClass().getDeclaredField("stringBridge");
        field.setAccessible(true);
        StringBridge stringBridge = (StringBridge)field.get(fieldBridge);
        Assert.assertTrue((String)"There should only be a single instance of DefaultStringBridge", (DefaultStringBridge.INSTANCE == stringBridge ? 1 : 0) != 0);
    }

    private FieldDescriptor getFieldDescriptor(Class<?> clazz, String fieldName) {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, clazz);
        return typeDescriptor.getIndexedField(fieldName);
    }

    @Indexed
    public static class Foo {
        @DocumentId
        private long id;
        @org.hibernate.search.annotations.Field(bridge=@FieldBridge(impl=DefaultStringBridge.class))
        private String foo;
    }
}

