/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.builtin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.test.bridge.builtin.Book;
import org.hibernate.search.test.util.impl.ClasspathResourceAsFile;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TikaBridgeInputTypeTest {
    private static final String TEST_DOCUMENT_PDF_1 = "/org/hibernate/search/test/bridge/builtin/test-document-3.pdf";
    private static final String TEST_DOCUMENT_PDF_2 = "/org/hibernate/search/test/bridge/builtin/test-document-2.pdf";
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Book.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);
    @Rule
    public final ClasspathResourceAsFile testDocumentPdf1 = new ClasspathResourceAsFile(this.getClass(), "/org/hibernate/search/test/bridge/builtin/test-document-3.pdf");
    @Rule
    public final ClasspathResourceAsFile testDocumentPdf2 = new ClasspathResourceAsFile(this.getClass(), "/org/hibernate/search/test/bridge/builtin/test-document-2.pdf");

    @Test
    public void testDefaultTikaBridgeWithListOfString() throws Exception {
        String content1 = this.testDocumentPdf1.get().getAbsolutePath();
        String content2 = this.testDocumentPdf2.get().getAbsolutePath();
        this.helper.add(new Book(1, content1, content2));
        List<EntityInfo> resultWithLucene = this.search("contentAsListOfString", "Lucene");
        Assert.assertEquals((String)"there should be a match", (long)1L, (long)resultWithLucene.size());
        List<EntityInfo> resultWithTika = this.search("contentAsListOfString", "Tika");
        Assert.assertEquals((String)"there should be a match", (long)1L, (long)resultWithTika.size());
    }

    @Test
    public void testDefaultTikaBridgeWithBlob() throws Exception {
        Blob content = this.dataAsBlob(this.testDocumentPdf1.get());
        this.helper.add(new Book(1, content), new Book(2));
        this.assertSearchMatches("contentAsBlob");
    }

    @Test
    public void testDefaultTikaBridgeWithByteArray() throws Exception {
        byte[] content = this.dataAsBytes(this.testDocumentPdf1.get());
        this.helper.add(new Book(1, content), new Book(2));
        this.assertSearchMatches("contentAsBytes");
    }

    @Test
    public void testDefaultTikaBridgeWithURI() throws Exception {
        URI content = this.testDocumentPdf1.get().toURI();
        this.helper.add(new Book(1, content), new Book(2));
        this.assertSearchMatches("contentAsURI");
    }

    private List<EntityInfo> search(String field, String keyword) throws ParseException {
        ExtendedSearchIntegrator integrator = this.sfHolder.getSearchFactory();
        QueryParser parser = new QueryParser(field, TestConstants.standardAnalyzer);
        Query query = parser.parse(keyword);
        List result = integrator.createHSQuery(query, new Class[]{Book.class}).queryEntityInfos();
        return result;
    }

    private void assertSearchMatches(String field) throws ParseException {
        this.helper.assertThat(field, "foo").from(Book.class).hasResultSize(0);
        this.helper.assertThat(field, "lucene").from(Book.class).hasResultSize(1);
        this.helper.assertThat(field, "null").from(Book.class).hasResultSize(1);
        this.helper.assertThat().from(Book.class).hasResultSize(2);
    }

    private Blob dataAsBlob(File file) throws IOException {
        byte[] byteArray = this.dataAsBytes(file);
        try {
            return new SerialBlob(byteArray);
        }
        catch (SQLException e) {
            throw new AssertionFailure("Unexpected error creating a blob", (Throwable)e);
        }
    }

    private byte[] dataAsBytes(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }
}

