/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

public class ExpectedLog4jLog
implements TestRule {
    private final List<LogExpectation> expectations = new ArrayList<LogExpectation>();
    private TestAppender currentAppender;

    public static ExpectedLog4jLog create() {
        return new ExpectedLog4jLog();
    }

    private ExpectedLog4jLog() {
    }

    public Statement apply(Statement base, org.junit.runner.Description description) {
        return new ExpectedLogStatement(base);
    }

    public LogExpectation expectEvent(Matcher<? extends LoggingEvent> matcher) {
        LogExpectation expectation = new LogExpectation(matcher);
        this.expectations.add(expectation);
        if (this.currentAppender != null) {
            this.currentAppender.addChecker(expectation.createChecker());
        }
        return expectation;
    }

    public LogExpectation expectEvent(Level level, Matcher<? super Throwable> throwableMatcher, String containedString, String ... otherContainedStrings) {
        return this.expectEvent((Matcher<? extends LoggingEvent>)CoreMatchers.allOf(this.eventLevelMatcher(level), this.eventThrowableMatcher(throwableMatcher), this.eventMessageMatcher(this.containsAllStrings(containedString, otherContainedStrings))));
    }

    @Deprecated
    public void expectEventMissing(Matcher<? extends LoggingEvent> matcher) {
        this.expectEvent(matcher).never();
    }

    public LogExpectation expectLevel(Level level) {
        return this.expectEvent(this.eventLevelMatcher(level));
    }

    @Deprecated
    public void expectLevelMissing(Level level) {
        this.expectLevel(level).never();
    }

    public LogExpectation expectMessage(String containedString) {
        return this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)containedString));
    }

    @Deprecated
    public void expectMessageMissing(String containedString) {
        this.expectMessage(containedString).never();
    }

    public LogExpectation expectMessage(String containedString, String ... otherContainedStrings) {
        return this.expectMessage(this.containsAllStrings(containedString, otherContainedStrings));
    }

    @Deprecated
    public void expectMessageMissing(String containedString, String ... otherContainedStrings) {
        this.expectMessage(containedString, otherContainedStrings).times(0);
    }

    public LogExpectation expectMessage(Matcher<String> matcher) {
        return this.expectEvent(this.eventMessageMatcher(matcher));
    }

    @Deprecated
    public void expectMessageMissing(Matcher<String> matcher) {
        this.expectMessage(matcher).times(0);
    }

    private Matcher<String> containsAllStrings(String containedString, String ... otherContainedStrings) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.add(CoreMatchers.containsString((String)containedString));
        for (String otherContainedString : otherContainedStrings) {
            matchers.add(CoreMatchers.containsString((String)otherContainedString));
        }
        return CoreMatchers.allOf(matchers);
    }

    private Matcher<LoggingEvent> eventLevelMatcher(final Level level) {
        return new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with ").appendValue((Object)level).appendText(" level or higher");
            }

            protected boolean matchesSafely(LoggingEvent item) {
                return item.getLevel().isGreaterOrEqual((Priority)level);
            }
        };
    }

    private Matcher<LoggingEvent> eventThrowableMatcher(final Matcher<? super Throwable> throwableMatcher) {
        return new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with throwable ").appendValue((Object)throwableMatcher);
            }

            protected boolean matchesSafely(LoggingEvent item) {
                ThrowableInformation throwableInfo = item.getThrowableInformation();
                return throwableMatcher.matches((Object)(throwableInfo == null ? null : throwableInfo.getThrowable()));
            }
        };
    }

    private Matcher<LoggingEvent> eventMessageMatcher(final Matcher<String> messageMatcher) {
        return new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with message matching ");
                messageMatcher.describeTo(description);
            }

            protected boolean matchesSafely(LoggingEvent item) {
                return messageMatcher.matches(item.getMessage());
            }
        };
    }

    private static String buildFailureMessage(Set<LogChecker> failingCheckers) {
        StringDescription description = new StringDescription();
        description.appendText("Produced logs did not meet the following expectations:\n");
        for (LogChecker failingChecker : failingCheckers) {
            failingChecker.appendFailure((Description)description, "\n\t");
        }
        return description.toString();
    }

    public static class LogChecker {
        private final LogExpectation expectation;
        private int count = 0;
        private List<LoggingEvent> extraEvents;

        public LogChecker(LogExpectation expectation) {
            this.expectation = expectation;
        }

        void process(LoggingEvent event) {
            if (this.expectation.getMaxExpectedCount() == null && this.expectation.getMinExpectedCount() <= this.count) {
                return;
            }
            if (this.expectation.getMatcher().matches((Object)event)) {
                ++this.count;
            }
            if (this.expectation.getMaxExpectedCount() != null && this.count > this.expectation.getMaxExpectedCount()) {
                if (this.extraEvents == null) {
                    this.extraEvents = new ArrayList<LoggingEvent>();
                }
                this.extraEvents.add(event);
            }
        }

        boolean areExpectationsMet() {
            return this.expectation.getMinExpectedCount() <= this.count && (this.expectation.getMaxExpectedCount() == null || this.count <= this.expectation.getMaxExpectedCount());
        }

        void appendFailure(Description description, String newline) {
            description.appendText(newline);
            if (this.count < this.expectation.getMinExpectedCount()) {
                description.appendText("Expected at least " + this.expectation.getMinExpectedCount() + " time(s) ");
                this.expectation.getMatcher().describeTo(description);
                description.appendText(" but only got " + this.count + " such event(s).");
            }
            if (this.expectation.getMaxExpectedCount() != null && this.expectation.getMaxExpectedCount() < this.count) {
                description.appendText("Expected at most " + this.expectation.getMaxExpectedCount() + " time(s) ");
                this.expectation.getMatcher().describeTo(description);
                description.appendText(" but got " + this.count + " such event(s).");
                description.appendText(" Extra events: ");
                for (LoggingEvent extraEvent : this.extraEvents) {
                    description.appendText(newline);
                    description.appendText("\t - ");
                    description.appendText(extraEvent.getRenderedMessage());
                }
            }
        }
    }

    public static class LogExpectation {
        private final Matcher<?> matcher;
        private Integer expectedCount;

        LogExpectation(Matcher<?> matcher) {
            this.matcher = matcher;
        }

        public void never() {
            this.times(0);
        }

        public void once() {
            this.times(1);
        }

        public void times(int expectedCount) {
            if (this.expectedCount != null) {
                throw new IllegalStateException("Can only set log expectations once");
            }
            this.expectedCount = expectedCount;
        }

        LogChecker createChecker() {
            return new LogChecker(this);
        }

        Matcher<?> getMatcher() {
            return this.matcher;
        }

        int getMinExpectedCount() {
            return this.expectedCount == null ? 1 : this.expectedCount;
        }

        Integer getMaxExpectedCount() {
            return this.expectedCount;
        }
    }

    private class ExpectedLogStatement
    extends Statement {
        private final Statement next;

        ExpectedLogStatement(Statement base) {
            this.next = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            Logger logger = Logger.getRootLogger();
            TestAppender appender = new TestAppender();
            for (LogExpectation expectation : ExpectedLog4jLog.this.expectations) {
                appender.addChecker(expectation.createChecker());
            }
            ExpectedLog4jLog.this.currentAppender = appender;
            logger.addAppender((Appender)appender);
            try {
                this.next.evaluate();
            }
            finally {
                logger.removeAppender((Appender)appender);
            }
            Set<LogChecker> failingCheckers = appender.getFailingCheckers();
            if (!failingCheckers.isEmpty()) {
                Assert.fail((String)ExpectedLog4jLog.buildFailureMessage(failingCheckers));
            }
        }
    }

    private class TestAppender
    extends AppenderSkeleton {
        private final List<LogChecker> checkers = new ArrayList<LogChecker>();

        private TestAppender() {
        }

        void addChecker(LogChecker checker) {
            this.checkers.add(checker);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent event) {
            for (LogChecker checker : this.checkers) {
                checker.process(event);
            }
        }

        Set<LogChecker> getFailingCheckers() {
            HashSet<LogChecker> failingCheckers = new HashSet<LogChecker>();
            for (LogChecker checker : this.checkers) {
                if (checker.areExpectationsMet()) continue;
                failingCheckers.add(checker);
            }
            return failingCheckers;
        }
    }
}

