/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Facets;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-809")
public class DocumentFieldMetadataTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testStringFieldCanBeCOnfiguredForFaceting() {
        FacetMetadata facetMetadata = this.getSingleFacetMetadata(Foo.class, "name");
        Assert.assertEquals((String)"Unexpected facet name", (Object)"name", (Object)facetMetadata.getAbsoluteName());
        Assert.assertEquals((String)"Unexpected encoding type", (Object)FacetEncodingType.STRING, (Object)facetMetadata.getEncoding());
    }

    @Test
    public void testDateFieldCanBeConfiguredForFaceting() {
        FacetMetadata facetMetadata = this.getSingleFacetMetadata(Foobar.class, "date");
        Assert.assertEquals((String)"Unexpected facet name", (Object)"date", (Object)facetMetadata.getAbsoluteName());
        Assert.assertEquals((String)"Unexpected encoding type", (Object)FacetEncodingType.LONG, (Object)facetMetadata.getEncoding());
    }

    @Test
    public void testExplicitFacetName() {
        FacetMetadata facetMetadata = this.getSingleFacetMetadata(Fubar.class, "name");
        Assert.assertEquals((String)"Unexpected facet name", (Object)"facet_name", (Object)facetMetadata.getAbsoluteName());
        Assert.assertEquals((String)"Unexpected encoding type", (Object)FacetEncodingType.STRING, (Object)facetMetadata.getEncoding());
    }

    @Test
    public void testFacetFieldTargetsSpecificFieldAnnotation() {
        FacetMetadata facetMetadata = this.getSingleFacetMetadata(Baz.class, "facet_value");
        Assert.assertEquals((String)"Unexpected facet name", (Object)"facet_value", (Object)facetMetadata.getAbsoluteName());
        Assert.assertEquals((String)"Unexpected encoding type", (Object)FacetEncodingType.DOUBLE, (Object)facetMetadata.getEncoding());
    }

    @Test
    public void testMultipleFacetsAnnotation() {
        FacetMetadata facetMetadata = this.getSingleFacetMetadata(Qux.class, "value");
        Assert.assertEquals((String)"Unexpected facet name", (Object)"value", (Object)facetMetadata.getAbsoluteName());
        Assert.assertEquals((String)"Unexpected encoding type", (Object)FacetEncodingType.DOUBLE, (Object)facetMetadata.getEncoding());
        facetMetadata = this.getSingleFacetMetadata(Qux.class, "facet_value");
        Assert.assertEquals((String)"Unexpected facet name", (Object)"facet_value", (Object)facetMetadata.getAbsoluteName());
        Assert.assertEquals((String)"Unexpected encoding type", (Object)FacetEncodingType.STRING, (Object)facetMetadata.getEncoding());
    }

    @Test
    public void testAddingFacetToUnsupportedTypeThrowsException() {
        try {
            this.metadataProvider.getTypeMetadataFor(Bar.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
            Assert.fail((String)"Invalid facet configuration should throw exception. URI type cannot be faceted");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000264"));
        }
    }

    @Test
    public void testAddingFacetToUnanalyzedFieldThrowsException() {
        try {
            this.metadataProvider.getTypeMetadataFor(Snafu.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
            Assert.fail((String)"Field targeted for faceting cannot be analyzed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000273"));
        }
    }

    @Test
    public void testNumericFieldReferencingNonExistingFieldThrowsException() {
        this.expectedException.expect(SearchException.class);
        this.expectedException.expectMessage("HSEARCH000262");
        this.metadataProvider.getTypeMetadataFor(TypeWithNumericFieldReferringToNonExistantField.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
    }

    @Test
    public void testNumericFieldWithoutFieldThrowsException() {
        this.expectedException.expect(SearchException.class);
        this.expectedException.expectMessage("HSEARCH000262");
        this.metadataProvider.getTypeMetadataFor(TypeWithNumericFieldWithoutField.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
    }

    @Test
    public void testSeveralNumericFieldsReferringToSameFieldThrowException() {
        this.expectedException.expect(SearchException.class);
        this.expectedException.expectMessage("HSEARCH000300");
        this.metadataProvider.getTypeMetadataFor(TypeWithSeveralNumericFieldsReferringToSameField.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
    }

    private FacetMetadata getSingleFacetMetadata(Class<?> type, String fieldName) {
        TypeMetadata typeMetadata = this.metadataProvider.getTypeMetadataFor(type, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        DocumentFieldMetadata documentFieldMetadata = typeMetadata.getDocumentFieldMetadataFor(fieldName);
        Assert.assertTrue((String)"The field should be enabled for faceting", (boolean)documentFieldMetadata.hasFacets());
        Set facetMetadataSet = documentFieldMetadata.getFacetMetadata();
        Assert.assertEquals((String)"Unexpected number of metadata instances", (long)1L, (long)facetMetadataSet.size());
        return (FacetMetadata)facetMetadataSet.iterator().next();
    }

    @Indexed
    public class TypeWithSeveralNumericFieldsReferringToSameField {
        @DocumentId
        private Integer id;
        @NumericFields(value={@NumericField(forField="name"), @NumericField(forField="name")})
        @Field(name="name")
        private short name;
    }

    @Indexed
    public class TypeWithNumericFieldWithoutField {
        @DocumentId
        private Integer id;
        @NumericField
        private short name;
    }

    @Indexed
    public class TypeWithNumericFieldReferringToNonExistantField {
        @DocumentId
        private Integer id;
        @NumericField(forField="nonExistant")
        @Field
        private short name;
    }

    @Indexed
    public class Snafu {
        @DocumentId
        private Integer id;
        @Field
        @Facet
        private String name;
    }

    @Indexed
    public class Qux {
        @DocumentId
        private Integer id;
        @Fields(value={@Field(analyze=Analyze.NO), @Field(analyze=Analyze.NO, name="facet_value")})
        @Facets(value={@Facet, @Facet(forField="facet_value", encoding=FacetEncodingType.STRING)})
        private double value;
    }

    @Indexed
    public class Baz {
        @DocumentId
        private Integer id;
        @Fields(value={@Field(analyze=Analyze.NO), @Field(analyze=Analyze.NO, name="facet_value")})
        @Facet(forField="facet_value")
        private double value;
    }

    @Indexed
    public class Fubar {
        @DocumentId
        private Integer id;
        @Field(analyze=Analyze.NO)
        @Facet(name="facet_name")
        private String name;
    }

    @Indexed
    public class Foobar {
        @DocumentId
        private Integer id;
        @Field(analyze=Analyze.NO)
        @Facet
        private Date date;
    }

    @Indexed
    public class Bar {
        @DocumentId
        private Integer id;
        @Field(analyze=Analyze.NO)
        @Facet
        private URI uri;
    }

    @Indexed
    public class Foo {
        @DocumentId
        private Integer id;
        @Field(analyze=Analyze.NO)
        @Facet
        private String name;
    }
}

