/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class TestConstants {
    public static final Analyzer standardAnalyzer = new StandardAnalyzer();
    public static final Analyzer stopAnalyzer = new StopAnalyzer();
    public static final Analyzer simpleAnalyzer = new SimpleAnalyzer();
    public static final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private static final CallerProvider callerProvider = new CallerProvider();

    private TestConstants() {
    }

    public static Version getTargetLuceneVersion() {
        return Version.LATEST;
    }

    public static Path getTempTestDataDir() {
        try {
            Path tempTestDataDir = Files.createTempDirectory("hsearch-tests-", new FileAttribute[0]);
            tempTestDataDir.toFile().deleteOnExit();
            return tempTestDataDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary directory for tests", e);
        }
    }

    public static Path getIndexDirectory(Path parent) {
        return TestConstants.getIndexDirectory(parent, callerProvider.getCallerClass());
    }

    public static Path getIndexDirectory(Path parent, Class<?> requester) {
        Path indexDirPath = parent.resolve("indextemp-" + requester.getSimpleName());
        indexDirPath.toFile().deleteOnExit();
        String indexDir = indexDirPath.toAbsolutePath().toString();
        log.debugf("Using %s as index directory.", (Object)indexDir);
        return indexDirPath;
    }

    public static boolean arePerformanceTestsEnabled() {
        return Boolean.getBoolean("org.hibernate.search.enable_performance_tests");
    }

    private static class CallerProvider
    extends SecurityManager {
        private CallerProvider() {
        }

        public Class<?> getCallerClass() {
            return this.getClassContext()[2];
        }
    }
}

