/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.serialization;

import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-1815")
public class SerializationProviderMissingTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Book.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testExceptionMessage() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000275");
        this.thrown.expectMessage("hibernate-search-serialization-avro");
        ExtendedSearchIntegrator searchFactory = this.factoryHolder.getSearchFactory();
        IndexManager indexManager = searchFactory.getIndexManagerHolder().getIndexManager("books");
        indexManager.getSerializer();
    }

    @Indexed(index="books")
    private static class Book {
        @DocumentId
        long id;
        @Field
        String title;

        private Book() {
        }
    }
}

