/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.AppliedOnTypeAwareBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Test;

public class AppliedOnTypeAwareBridgeTest {
    @Test
    public void testTypeIsSetForField() {
        SearchIntegrator searchFactory = this.createSearchIntegrator(Foo.class);
        Foo foo = new Foo(0L);
        Work work = new Work((Object)foo, (Serializable)Long.valueOf(foo.getId()), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Test
    public void testTypeIsSetForGetter() {
        SearchIntegrator searchFactory = this.createSearchIntegrator(Bar.class);
        Bar bar = new Bar(0L);
        Work work = new Work((Object)bar, (Serializable)Long.valueOf(bar.getId()), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Test
    public void testTypeIsSetForClass() {
        SearchIntegrator searchFactory = this.createSearchIntegrator(Snafu.class);
        Snafu snafu = new Snafu(0L);
        Work work = new Work((Object)snafu, (Serializable)Long.valueOf(snafu.getId()), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private SearchIntegrator createSearchIntegrator(Class<?> clazz) {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(clazz);
        return new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
    }

    public static class TypeAssertingFieldBridge
    implements org.hibernate.search.bridge.FieldBridge,
    AppliedOnTypeAwareBridge,
    ParameterizedBridge {
        private String expectedTypeName;
        private String actualTypeName;

        public void setAppliedOnType(Class<?> returnType) {
            this.actualTypeName = returnType.getName();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Assert.assertTrue((String)"Type not set prior to calling #set of field bridge", (this.actualTypeName != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"Unexpected type", (Object)this.expectedTypeName, (Object)this.actualTypeName);
        }

        public void setParameterValues(Map<String, String> parameters) {
            this.expectedTypeName = parameters.get("type");
        }
    }

    @Indexed
    @ClassBridge(impl=TypeAssertingFieldBridge.class, params={@Parameter(name="type", value="org.hibernate.search.test.bridge.AppliedOnTypeAwareBridgeTest$Snafu")})
    public static class Snafu {
        @DocumentId
        private Long id;

        public Snafu(Long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }
    }

    @Indexed
    public static class Bar {
        @DocumentId
        private Long id;
        private Object test;

        public Bar(Long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        @Field(bridge=@FieldBridge(impl=TypeAssertingFieldBridge.class, params={@Parameter(name="type", value="java.lang.Object")}))
        public Object getTest() {
            return this.test;
        }
    }

    @Indexed
    public static class Foo {
        @DocumentId
        private Long id;
        @Field(bridge=@FieldBridge(impl=TypeAssertingFieldBridge.class, params={@Parameter(name="type", value="java.lang.Integer")}))
        private Integer test;

        public Foo(Long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }
    }
}

