/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.Duration;
import org.fest.assertions.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.DurationBridge;
import org.hibernate.search.exception.SearchException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DurationBridgeTest {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final DurationBridge BRIDGE = DurationBridge.INSTANCE;
    private static final Duration MAX_DURATION = Duration.ofNanos(Long.MAX_VALUE);
    private static final Duration MIN_DURATION = Duration.ofSeconds(-9223372036L, 999999999L);
    private static final Duration CUSTOM_DURATION = Duration.ofSeconds(-5808L, 10L);
    private static final Duration ZERO_DURATION = Duration.ZERO;
    private static final Duration OUT_OF_RANGE_DURATION = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_DURATION)).isEqualTo((Object)String.valueOf(MAX_DURATION.toNanos()));
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_DURATION)).isEqualTo((Object)String.valueOf(MIN_DURATION.toNanos()));
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_DURATION)).isEqualTo((Object)String.valueOf(CUSTOM_DURATION.toNanos()));
    }

    @Test
    public void testZeroObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)ZERO_DURATION)).isEqualTo((Object)"0");
    }

    @Test
    public void testExceptionValueTooSmall() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000297");
        BRIDGE.objectToString((Object)Duration.ofSeconds(-9223372037L, 999999999L));
    }

    @Test
    public void testExceptionValueTooBig() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000297");
        BRIDGE.objectToString((Object)OUT_OF_RANGE_DURATION);
    }
}

