/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.sharding;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.store.impl.NotShardedStrategy;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-472")
@RunWith(value=BMUnitRunner.class)
public class ShardingConfigurationTest {
    @Test
    public void testNoShardingIsUsedPerDefault() {
        MutableSearchFactory searchFactory = this.getSearchFactory(Collections.emptyMap());
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(Foo.class);
        Assert.assertEquals((String)"No sharding should be configured. Number of shards and sharding strategy are not set", NotShardedStrategy.class, entityIndexBinding.getSelectionStrategy().getClass());
    }

    @Test
    public void testSettingNumberOfShardsOnlySelectsIdHashSharding() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "2");
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(Foo.class);
        Assert.assertEquals((String)"IdHashShardingStrategy should be selected due to number of shards being set", IdHashShardingStrategy.class, entityIndexBinding.getSelectionStrategy().getClass());
    }

    @Test
    public void testSettingNegativeNumberOfShardsThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "-1");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000191"));
        }
    }

    @Test
    public void testSettingZeroNumberOfShardsThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "0");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000191"));
        }
    }

    @Test
    public void testSettingStringValueAsNumberOfShardsThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "snafu");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000192"));
        }
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.util.logging.impl.Log_$logger", targetMethod="idHashShardingWithSingleShard", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testSettingIdHashShardingStrategyWithoutNumberOfShards")
    public void testSettingIdHashShardingStrategyWithoutNumberOfShards() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", IdHashShardingStrategy.class.getName());
        EntityIndexBinding entityIndexBinding = this.getSearchFactory(shardingProperties).getIndexBinding(Foo.class);
        Assert.assertTrue((String)"Without specifying number of shards, 1 should be assumed", (entityIndexBinding.getSelectionStrategy().getIndexManagersForAllShards().length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong invocation count", (long)1L, (long)BytemanHelper.getAndResetInvocationCount());
    }

    @Test
    public void testSettingCustomIndexShardingStrategy() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", DummyIndexShardingStrategy.class.getName());
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "2");
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(Foo.class);
        Assert.assertEquals((String)"Explicitly set sharding strategy ignored", DummyIndexShardingStrategy.class, entityIndexBinding.getSelectionStrategy().getClass());
        Assert.assertTrue((String)"Number of shards is explicitly set, but ignored", (entityIndexBinding.getSelectionStrategy().getIndexManagersForAllShards().length == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSettingCustomShardIdentifierProvider() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", DummyShardIdentifierProvider.class.getName());
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(Foo.class);
        Assert.assertEquals((String)"Explicitly set shard id provider ignored", DummyShardIdentifierProvider.class, entityIndexBinding.getShardIdentifierProvider().getClass());
    }

    @Test
    public void testSettingUnknownStrategyClassThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", "snafu");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000194"));
        }
    }

    @Test
    public void testSettingCustomShardIdentifierProviderWithExplicitIndexName() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.foo.sharding_strategy", DummyShardIdentifierProvider.class.getName());
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(Foo.class);
        Assert.assertEquals((String)"Explicitly set shard id provider ignored", DummyShardIdentifierProvider.class, entityIndexBinding.getShardIdentifierProvider().getClass());
    }

    @Test
    public void testConfiguringDynamicallyCreatedShardViaConfiguration() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.foo.sharding_strategy", DummyShardIdentifierProvider.class.getName());
        shardingProperties.put("hibernate.search.foo.snafu.directory_provider", "filesystem");
        File indexDir = new File(TestConstants.getIndexDirectory(ShardingConfigurationTest.class));
        shardingProperties.put("hibernate.search.foo.snafu.indexBase", indexDir.getAbsolutePath());
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(Foo.class);
        IndexManager[] indexManagers = entityIndexBinding.getIndexManagers();
        Assert.assertTrue((String)"There should be two index managers", (indexManagers.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected index manager type", (boolean)(indexManagers[0] instanceof DirectoryBasedIndexManager));
        DirectoryBasedIndexManager directoryBasedIndexManager = (DirectoryBasedIndexManager)indexManagers[0];
        Assert.assertTrue((String)("Unexpected directory provider type: " + directoryBasedIndexManager.getDirectoryProvider().getClass()), (boolean)(directoryBasedIndexManager.getDirectoryProvider() instanceof FSDirectoryProvider));
    }

    private MutableSearchFactory getSearchFactory(Map<String, String> shardingProperties) {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest();
        for (Map.Entry<String, String> entry : shardingProperties.entrySet()) {
            configuration.addProperty(entry.getKey(), entry.getValue());
        }
        configuration.addClass(Foo.class);
        return (MutableSearchFactory)new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
    }

    public static class DummyShardIdentifierProvider
    implements ShardIdentifierProvider {
        private Set<String> shards = new HashSet<String>();

        public void initialize(Properties properties, BuildContext buildContext) {
            this.shards.add("snafu");
        }

        public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
            return null;
        }

        public Set<String> getShardIdentifiersForQuery(FullTextFilterImplementor[] fullTextFilters) {
            return this.shards;
        }

        public Set<String> getAllShardIdentifiers() {
            return this.shards;
        }
    }

    public static class DummyIndexShardingStrategy
    implements IndexShardingStrategy {
        private IndexManager[] indexManagers;

        public void initialize(Properties properties, IndexManager[] indexManagers) {
            this.indexManagers = indexManagers;
        }

        public IndexManager[] getIndexManagersForAllShards() {
            return this.indexManagers;
        }

        public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
            return null;
        }

        public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
            return null;
        }

        public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
            return null;
        }
    }

    @Indexed(index="foo")
    public static final class Foo {
        @DocumentId
        long id;
    }
}

