/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.impl.SortConfigurations;
import org.hibernate.search.reader.impl.ManagedMultiReader;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Rule;
import org.junit.Test;

public class ManagedMultiReaderTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Person.class, Customer.class);

    @Test
    public void testStandardReaderIsUsedIfAllSortsAreCovered() throws Exception {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        EntityIndexBinding binding = integrator.getIndexBinding(Person.class);
        IndexManager[] indexManagers = binding.getSelectionStrategy().getIndexManagersForQuery((FullTextFilterImplementor[])new FullTextFilterImpl[0]);
        Sort sort = new Sort(new SortField[]{new SortField("ageForIntSorting", SortField.Type.INT), new SortField("ageForStringSorting", SortField.Type.STRING)});
        SortConfigurations configuredSorts = new SortConfigurations.Builder().setIndex("test").setEntityType(Person.class).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder().fieldName("ageForIntSorting").build(), new SortableFieldMetadata.Builder().fieldName("ageForStringSorting").build())).build();
        try (ManagedMultiReader reader = (ManagedMultiReader)MultiReaderFactory.openReader((SortConfigurations)configuredSorts, (Sort)sort, (IndexManager[])indexManagers);){
            List actualReaders = reader.getSubReaders();
            Assertions.assertThat((List)actualReaders).hasSize(1);
            Assertions.assertThat((String)((IndexReader)actualReaders.get(0)).getClass().getSimpleName()).isEqualTo((Object)"StandardDirectoryReader");
        }
    }

    @Test
    public void testUninvertingReaderIsUsedIfNotAllSortsAreCovered() throws Exception {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        EntityIndexBinding binding = integrator.getIndexBinding(Person.class);
        IndexManager[] indexManagers = binding.getSelectionStrategy().getIndexManagersForQuery((FullTextFilterImplementor[])new FullTextFilterImpl[0]);
        Sort sort = new Sort(new SortField[]{new SortField("ageForIntSorting", SortField.Type.INT), new SortField("ageForStringSorting", SortField.Type.STRING)});
        SortConfigurations configuredSorts = new SortConfigurations.Builder().setIndex("person").setEntityType(Person.class).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder().fieldName("ageForStringSorting").build())).build();
        try (ManagedMultiReader reader = (ManagedMultiReader)MultiReaderFactory.openReader((SortConfigurations)configuredSorts, (Sort)sort, (IndexManager[])indexManagers);){
            List actualReaders = reader.getSubReaders();
            Assertions.assertThat((List)actualReaders).hasSize(1);
            Assertions.assertThat((String)((IndexReader)actualReaders.get(0)).getClass().getSimpleName()).isEqualTo((Object)"UninvertingDirectoryReader");
        }
    }

    @Test
    public void testCombinationOfStandardAndUninvertingReaderAsRequiredToSortOnInvolvedIndexes() throws Exception {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        EntityIndexBinding binding = integrator.getIndexBinding(Person.class);
        ArrayList<IndexManager> indexManagers = new ArrayList<IndexManager>(Arrays.asList(binding.getSelectionStrategy().getIndexManagersForQuery((FullTextFilterImplementor[])new FullTextFilterImpl[0])));
        binding = integrator.getIndexBinding(Customer.class);
        indexManagers.addAll(Arrays.asList(binding.getSelectionStrategy().getIndexManagersForQuery((FullTextFilterImplementor[])new FullTextFilterImpl[0])));
        Sort sort = new Sort(new SortField[]{new SortField("ageForIntSorting", SortField.Type.INT), new SortField("ageForStringSorting", SortField.Type.STRING)});
        SortConfigurations configuredSorts = new SortConfigurations.Builder().setIndex("person").setEntityType(Person.class).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder().fieldName("ageForStringSorting").build())).setIndex("customer").setEntityType(Customer.class).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder().fieldName("ageForStringSorting").build(), new SortableFieldMetadata.Builder().fieldName("ageForIntSorting").build())).build();
        try (ManagedMultiReader reader = (ManagedMultiReader)MultiReaderFactory.openReader((SortConfigurations)configuredSorts, (Sort)sort, (IndexManager[])indexManagers.toArray(new IndexManager[indexManagers.size()]));){
            List actualReaders = reader.getSubReaders();
            Assertions.assertThat((List)actualReaders).hasSize(2);
            Assertions.assertThat((String)((IndexReader)actualReaders.get(0)).getClass().getSimpleName()).isEqualTo((Object)"UninvertingDirectoryReader");
            Assertions.assertThat((String)((IndexReader)actualReaders.get(1)).getClass().getSimpleName()).isEqualTo((Object)"StandardDirectoryReader");
        }
    }

    @Indexed(index="customer")
    private class Customer {
        @DocumentId
        int id;

        private Customer() {
        }
    }

    @Indexed(index="person")
    private class Person {
        @DocumentId
        int id;

        private Person() {
        }
    }
}

