/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

public class TransactionsExpectedTest {
    @Test
    public void testDefaultImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        this.verifyTransactionsExpectedOption(true, cfg);
    }

    @Test
    public void testTransactionsNotExpected() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setTransactionsExpected(false);
        this.verifyTransactionsExpectedOption(false, cfg);
    }

    @Test
    public void testTransactionsExpected() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setTransactionsExpected(true);
        this.verifyTransactionsExpectedOption(true, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTransactionsExpectedOption(boolean expectation, SearchConfigurationForTest cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addClass(Document.class);
        try (MutableSearchFactory sf = (MutableSearchFactory)new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();){
            Assert.assertEquals((Object)expectation, (Object)sf.isTransactionManagerExpected());
            sf.addClasses(new Class[]{Dvd.class});
            Assert.assertEquals((Object)expectation, (Object)sf.isTransactionManagerExpected());
        }
    }

    @Indexed
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }

    public static final class Document {
        long id;
        String title;
    }
}

