/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.junit.rules.ExternalResource;

public class ClasspathResourceAsFile
extends ExternalResource {
    private File parentDirectory;
    private final URL url;
    private File file;
    private boolean hasCreatedTempFile;

    public ClasspathResourceAsFile(Class<?> clazz, String path) {
        this(clazz, path, null);
    }

    public ClasspathResourceAsFile(Class<?> clazz, String path, File parentDirectory) {
        this.url = clazz.getResource(path);
        this.parentDirectory = parentDirectory;
    }

    public File get() {
        return this.file;
    }

    protected void before() throws Throwable {
        this.createFileIfNecessary();
    }

    protected void after() {
        this.deleteFileIfNecessary();
    }

    private void createFileIfNecessary() throws IOException {
        this.file = FileUtils.toFile((URL)this.url);
        if (this.file == null) {
            this.file = File.createTempFile("classPathResourceAsFile", this.getOriginalExtension(), this.parentDirectory);
            this.hasCreatedTempFile = true;
            try (InputStream input = this.url.openStream();
                 FileOutputStream output = new FileOutputStream(this.file);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
    }

    private void deleteFileIfNecessary() {
        try {
            if (this.hasCreatedTempFile) {
                FileUtils.deleteQuietly((File)this.file);
            }
        }
        finally {
            this.file = null;
            this.hasCreatedTempFile = false;
        }
    }

    private String getOriginalExtension() {
        String extension = FilenameUtils.getExtension((String)this.url.getFile());
        extension = extension == null || extension.isEmpty() ? null : "." + extension;
        return extension;
    }
}

