/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ExceptionMatcherBuilder {
    private final List<Matcher<?>> matchers = new ArrayList();
    private final List<Matcher<?>> suppressedMatchers = new ArrayList();

    public static ExceptionMatcherBuilder isException(Class<? extends Throwable> clazz) {
        return new ExceptionMatcherBuilder(clazz);
    }

    private ExceptionMatcherBuilder(Class<? extends Throwable> clazz) {
        this.matchers.add(CoreMatchers.instanceOf(clazz));
    }

    public ExceptionMatcherBuilder withSuppressed(Matcher<?> matcher) {
        this.suppressedMatchers.add(matcher);
        return this;
    }

    public ExceptionMatcherBuilder causedBy(Class<? extends Throwable> clazz) {
        return new NestedExceptionCauseMatcherBuilder(clazz);
    }

    public Matcher<? super Throwable> build() {
        if (this.matchers.size() == 1 && this.suppressedMatchers.isEmpty()) {
            return this.castedMatchers().get(0);
        }
        if (!this.suppressedMatchers.isEmpty()) {
            Matcher[] suppressedMatchersAsArray = this.castedSuppressedMatchers().toArray(new Matcher[this.suppressedMatchers.size()]);
            this.matching(ExceptionMatcherBuilder.hasSuppressed(CoreMatchers.hasItems((Matcher[])suppressedMatchersAsArray)));
            this.suppressedMatchers.clear();
        }
        return CoreMatchers.allOf(this.castedMatchers());
    }

    private List<Matcher<? super Throwable>> castedMatchers() {
        return new ArrayList<Matcher<? super Throwable>>(this.matchers);
    }

    private List<Matcher<? super Throwable>> castedSuppressedMatchers() {
        return new ArrayList<Matcher<? super Throwable>>(this.suppressedMatchers);
    }

    public ExceptionMatcherBuilder matching(Matcher<?> messageMatcher) {
        this.matchers.add(messageMatcher);
        return this;
    }

    public ExceptionMatcherBuilder withMessage(String contained) {
        return this.withMessage((Matcher<String>)CoreMatchers.containsString((String)contained));
    }

    public ExceptionMatcherBuilder withMessage(Matcher<String> messageMatcher) {
        return this.matching(ExceptionMatcherBuilder.hasMessage(messageMatcher));
    }

    private static Matcher<Throwable> hasMessage(Matcher<String> matcher) {
        return new ThrowableMessageMatcher(matcher);
    }

    private static Matcher<Throwable> hasCause(Matcher<?> matcher) {
        return new ThrowableCauseMatcher(matcher);
    }

    private static Matcher<Throwable> hasSuppressed(Matcher<?> suppressedMatcher) {
        return new ThrowableSuppressedMatcher(suppressedMatcher);
    }

    public static class ThrowableSuppressedMatcher
    extends TypeSafeMatcher<Throwable> {
        private final Matcher<?> suppressedMatcher;

        public ThrowableSuppressedMatcher(Matcher<?> suppressedMatcher) {
            this.suppressedMatcher = suppressedMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("exception with suppressed ");
            description.appendDescriptionOf(this.suppressedMatcher);
        }

        protected boolean matchesSafely(Throwable item) {
            return this.suppressedMatcher.matches(Arrays.asList(item.getSuppressed()));
        }

        protected void describeMismatchSafely(Throwable item, Description description) {
            description.appendText("suppressed ");
            this.suppressedMatcher.describeMismatch(Arrays.asList(item.getSuppressed()), description);
        }
    }

    public static class ThrowableCauseMatcher
    extends TypeSafeMatcher<Throwable> {
        private final Matcher<?> causeMatcher;

        public ThrowableCauseMatcher(Matcher<?> causeMatcher) {
            this.causeMatcher = causeMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("exception with cause ");
            description.appendDescriptionOf(this.causeMatcher);
        }

        protected boolean matchesSafely(Throwable item) {
            return this.causeMatcher.matches((Object)item.getCause());
        }

        protected void describeMismatchSafely(Throwable item, Description description) {
            description.appendText("cause ");
            this.causeMatcher.describeMismatch((Object)item.getCause(), description);
        }
    }

    public static class ThrowableMessageMatcher
    extends TypeSafeMatcher<Throwable> {
        private final Matcher<String> fMatcher;

        public ThrowableMessageMatcher(Matcher<String> matcher) {
            this.fMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("exception with message ");
            description.appendDescriptionOf(this.fMatcher);
        }

        protected boolean matchesSafely(Throwable item) {
            return this.fMatcher.matches((Object)item.getMessage());
        }

        protected void describeMismatchSafely(Throwable item, Description description) {
            description.appendText("message ");
            this.fMatcher.describeMismatch((Object)item.getMessage(), description);
        }
    }

    private class NestedExceptionCauseMatcherBuilder
    extends ExceptionMatcherBuilder {
        public NestedExceptionCauseMatcherBuilder(Class<? extends Throwable> clazz) {
            super(clazz);
        }

        @Override
        public Matcher<? super Throwable> build() {
            Matcher<? super Throwable> myMatcher = super.build();
            ExceptionMatcherBuilder.this.matching(ExceptionMatcherBuilder.hasCause(myMatcher));
            return ExceptionMatcherBuilder.this.build();
        }
    }
}

