/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-1320")
@RunWith(value=BMUnitRunner.class)
@Category(value={SkipOnElasticsearch.class})
public class SharedReleasesLocksTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Book.class).withProperty("hibernate.search.default.exclusive_index_use", "false");

    @Test
    @BMRule(targetClass="org.hibernate.search.backend.impl.lucene.IndexWriterHolder", targetMethod="getIndexWriter(ErrorContextBuilder)", condition="NOT flagged(\"failedPreviousWrite\")", action="flag(\"failedPreviousWrite\"); \nreturn null; ", name="SharedReleasesLocksTest")
    public void testPropertiesIndexing() throws IOException {
        this.writeABook(1L, "lock contention");
        this.writeABook(2L, "no contention");
        IndexManager indexManager = this.sfHolder.getSearchFactory().getIndexManagerHolder().getIndexManager("books");
        DirectoryBasedIndexManager dbim = (DirectoryBasedIndexManager)indexManager;
        Directory directory = dbim.getDirectoryProvider().getDirectory();
        Assert.assertFalse((String)"Index lock leaked!", (boolean)IndexWriter.isLocked((Directory)directory));
    }

    private void writeABook(long id, String bookTitle) {
        Book book = new Book();
        book.id = id;
        book.title = bookTitle;
        Work work = new Work((Object)book, (Serializable)Long.valueOf(book.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Indexed(index="books")
    private static class Book {
        @DocumentId
        long id;
        @Field
        String title;

        private Book() {
        }
    }
}

