/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.io.Serializable;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@Category(value={SkipOnElasticsearch.class})
public class SyncWorkProcessorShutDownTest {
    @Rule
    public SearchFactoryHolder sfAsyncExclusiveIndex = new SearchFactoryHolder(Quote.class).withProperty("hibernate.search.default.exclusive_index_use", "true");

    @Test
    @BMRule(targetClass="org.apache.lucene.index.IndexWriter", targetMethod="commit", action="throw new Error(\"error!\")", name="commitError")
    public void testErrorHandlingDuringCommit() throws Exception {
        this.writeData(this.sfAsyncExclusiveIndex);
        this.sfAsyncExclusiveIndex.getSearchFactory().close();
    }

    private void writeData(SearchFactoryHolder sfHolder) {
        Quote quote = new Quote(1, "description");
        Work work = new Work((Object)quote, (Serializable)Integer.valueOf(1), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }
}

