/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Collection;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.SortableFields;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeMetadataTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testMultipleDocumentIdsCauseException() {
        try {
            this.metadataProvider.getTypeMetadataFor(Foo.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000167: More than one @DocumentId specified on entity 'org.hibernate.search.test.configuration.TypeMetadataTest$Foo'", (Object)e.getMessage());
        }
    }

    @Test
    public void testRetrievalOfSortableFieldMetadata() {
        TypeMetadata metadata = this.metadataProvider.getTypeMetadataFor(Bar.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        Set fieldMetadata = metadata.getPropertyMetadataForProperty("name").getSortableFieldMetadata();
        Assertions.assertThat((Collection)fieldMetadata).onProperty("absoluteName").containsOnly(new Object[]{"name"});
        fieldMetadata = metadata.getPropertyMetadataForProperty("age").getSortableFieldMetadata();
        Assertions.assertThat((Collection)fieldMetadata).onProperty("absoluteName").containsOnly(new Object[]{"ageForStringSorting", "ageForIntSorting"});
    }

    @Indexed
    public class Bar {
        @DocumentId
        private Integer id;
        @Field
        @SortableField
        private String name;
        @SortableFields(value={@SortableField(forField="ageForStringSorting"), @SortableField(forField="ageForIntSorting")})
        @Fields(value={@Field(name="ageForStringSorting", analyze=Analyze.NO, bridge=@FieldBridge(impl=IntegerBridge.class)), @Field(name="ageForIntSorting", analyze=Analyze.NO)})
        private long age;
    }

    @Indexed
    public class Foo {
        @DocumentId
        private Integer id;
        @DocumentId
        private String name;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

