/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.indexedembedded;

import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-3339")
public class ContainedEntityWithSpatialBridgesTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    private SearchIntegrator integrator;
    private final SearchITHelper helper = new SearchITHelper(new SearchITHelper.SearchIntegratorProvider(){

        @Override
        public SearchIntegrator get() {
            return ContainedEntityWithSpatialBridgesTest.this.integrator;
        }
    });

    @Test
    public void typeSpatialBridgeNotTriggeringBootstrapException() {
        SearchConfigurationForTest config = new SearchConfigurationForTest().addClasses(ContainingForTypeSpatialBridge.class, ContainedForTypeSpatialBridge.class);
        this.integrator = this.integratorResource.create(config);
        QueryBuilder builder = this.helper.queryBuilder(ContainingForTypeSpatialBridge.class);
        Query initialCoordinatesQuery = builder.spatial().onField("contained.location").within(100.0, Unit.KM).ofLatitude(12.0).andLongitude(12.0).createQuery();
        Query updatedCoordinatesQuery = builder.spatial().onField("contained.location").within(100.0, Unit.KM).ofLatitude(-12.0).andLongitude(-12.0).createQuery();
        ContainingForTypeSpatialBridge containing = new ContainingForTypeSpatialBridge();
        containing.id = 1;
        ContainedForTypeSpatialBridge contained = new ContainedForTypeSpatialBridge();
        contained.containing = containing;
        containing.contained = contained;
        contained.latitude = 12.0;
        contained.longitude = 12.0;
        this.helper.add(containing);
        this.helper.assertThat(initialCoordinatesQuery).from(ContainingForTypeSpatialBridge.class).matchesExactlyIds(Integer.valueOf(1));
        this.helper.assertThat(updatedCoordinatesQuery).from(ContainingForTypeSpatialBridge.class).matchesNone();
        contained.latitude = -12.0;
        contained.longitude = -12.0;
        this.helper.add(contained);
        this.helper.assertThat(initialCoordinatesQuery).from(ContainingForTypeSpatialBridge.class).matchesNone();
        this.helper.assertThat(updatedCoordinatesQuery).from(ContainingForTypeSpatialBridge.class).matchesExactlyIds(Integer.valueOf(1));
    }

    @Test
    public void propertySpatialBridgeNotTriggeringBootstrapException() {
        SearchConfigurationForTest config = new SearchConfigurationForTest().addClasses(ContainingForPropertySpatialBridge.class, ContainedForPropertySpatialBridge.class);
        this.integrator = this.integratorResource.create(config);
        QueryBuilder builder = this.helper.queryBuilder(ContainingForPropertySpatialBridge.class);
        Query initialCoordinatesQuery = builder.spatial().onField("contained.location").within(100.0, Unit.KM).ofLatitude(12.0).andLongitude(12.0).createQuery();
        Query updatedCoordinatesQuery = builder.spatial().onField("contained.location").within(100.0, Unit.KM).ofLatitude(-12.0).andLongitude(-12.0).createQuery();
        ContainingForPropertySpatialBridge containing = new ContainingForPropertySpatialBridge();
        containing.id = 1;
        ContainedForPropertySpatialBridge contained = new ContainedForPropertySpatialBridge();
        contained.containing = containing;
        containing.contained = contained;
        contained.coordinates = (Coordinates)Point.fromDegrees((double)12.0, (double)12.0);
        this.helper.add(containing);
        this.helper.assertThat(initialCoordinatesQuery).from(ContainingForPropertySpatialBridge.class).matchesExactlyIds(Integer.valueOf(1));
        this.helper.assertThat(updatedCoordinatesQuery).from(ContainingForPropertySpatialBridge.class).matchesNone();
        contained.coordinates = (Coordinates)Point.fromDegrees((double)-12.0, (double)-12.0);
        this.helper.add(contained);
        this.helper.assertThat(initialCoordinatesQuery).from(ContainingForPropertySpatialBridge.class).matchesNone();
        this.helper.assertThat(updatedCoordinatesQuery).from(ContainingForPropertySpatialBridge.class).matchesExactlyIds(Integer.valueOf(1));
    }

    public static class ContainedForPropertySpatialBridge {
        @ContainedIn
        private ContainingForPropertySpatialBridge containing;
        @Spatial(name="location")
        private Coordinates coordinates;

        public Coordinates getCoordinates() {
            return this.coordinates;
        }
    }

    @Indexed
    private static class ContainingForPropertySpatialBridge {
        @DocumentId
        private Integer id;
        @IndexedEmbedded
        private ContainedForPropertySpatialBridge contained;

        private ContainingForPropertySpatialBridge() {
        }
    }

    @Spatial(name="location")
    public static class ContainedForTypeSpatialBridge {
        @ContainedIn
        private ContainingForTypeSpatialBridge containing;
        private Double latitude;
        private Double longitude;

        @Latitude(of="location")
        public Double getLatitude() {
            return this.latitude;
        }

        @Longitude(of="location")
        public Double getLongitude() {
            return this.longitude;
        }
    }

    @Indexed
    private static class ContainingForTypeSpatialBridge {
        @DocumentId
        private Integer id;
        @IndexedEmbedded
        private ContainedForTypeSpatialBridge contained;

        private ContainingForTypeSpatialBridge() {
        }
    }
}

