/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.test.configuration.mutablefactory.A;
import org.hibernate.search.test.configuration.mutablefactory.B;
import org.hibernate.search.test.configuration.mutablefactory.C;
import org.hibernate.search.test.configuration.mutablefactory.generated.Generated;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class MutableFactoryTest {
    @Test
    public void testCreateEmptyFactory() throws Exception {
        SearchIntegrator si = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchIntegrator();
        Throwable throwable = null;
        if (si != null) {
            if (throwable != null) {
                try {
                    si.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                si.close();
            }
        }
    }

    @Test
    public void testAddingClassFullModel() throws Exception {
        SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchIntegrator();
        SearchIntegratorBuilder builder = new SearchIntegratorBuilder();
        searchIntegrator = builder.currentSearchIntegrator(searchIntegrator).addClass(A.class).buildSearchIntegrator();
        TransactionContextForTest tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, searchIntegrator, tc);
        tc.end();
        QueryParser parser = new QueryParser("name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        HSQuery hsQuery = searchIntegrator.createHSQuery(luceneQuery, new Class[]{A.class});
        int size = hsQuery.queryResultSize();
        Assert.assertEquals((long)1L, (long)size);
        searchIntegrator = builder.currentSearchIntegrator(searchIntegrator).addClass(B.class).buildSearchIntegrator();
        tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, searchIntegrator, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        hsQuery = searchIntegrator.createHSQuery(luceneQuery, new Class[]{B.class});
        size = hsQuery.queryResultSize();
        Assert.assertEquals((long)1L, (long)size);
        searchIntegrator.close();
    }

    @Test
    public void testAddingClassSimpleAPI() throws Exception {
        SearchIntegrator sf = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchIntegrator();
        sf.addClasses(new Class[]{A.class});
        TransactionContextForTest tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, sf, tc);
        tc.end();
        QueryParser parser = new QueryParser("name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        HSQuery hsQuery = sf.createHSQuery(luceneQuery, new Class[]{A.class});
        int size = hsQuery.queryResultSize();
        Assert.assertEquals((long)1L, (long)size);
        sf.addClasses(new Class[]{B.class, C.class});
        tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, sf, tc);
        MutableFactoryTest.doIndexWork(new C(1, "Vincent"), 1, sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        hsQuery = sf.createHSQuery(luceneQuery, new Class[]{B.class});
        size = hsQuery.queryResultSize();
        Assert.assertEquals((long)1L, (long)size);
        luceneQuery = parser.parse("Vincent");
        hsQuery = sf.createHSQuery(luceneQuery, new Class[]{C.class});
        size = hsQuery.queryResultSize();
        Assert.assertEquals((long)1L, (long)size);
        sf.close();
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testAddingClassSimpleAPIwithJMX() throws Exception {
        SearchIntegrator sf = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest().addClass(A.class).addProperty("hibernate.search.jmx_enabled", Boolean.TRUE.toString()).addProperty("hibernate.search.generate_statistics", Boolean.TRUE.toString()).addProperty("com.sun.management.jmxremote", Boolean.TRUE.toString())).buildSearchIntegrator();
        TransactionContextForTest tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, sf, tc);
        tc.end();
        QueryParser parser = new QueryParser("name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        HSQuery hsQuery = sf.createHSQuery(luceneQuery, new Class[]{A.class});
        hsQuery.getTimeoutManager().start();
        List entityInfos = hsQuery.queryEntityInfos();
        Assert.assertEquals((long)1L, (long)entityInfos.size());
        Assert.assertEquals((long)1L, (long)sf.getStatistics().getSearchQueryExecutionCount());
        Assert.assertEquals((long)1L, (long)sf.getStatistics().getIndexedClassNames().size());
        hsQuery.getTimeoutManager().stop();
        sf.addClasses(new Class[]{B.class, C.class});
        tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, sf, tc);
        MutableFactoryTest.doIndexWork(new C(1, "Vincent"), 1, sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        hsQuery = sf.createHSQuery(luceneQuery, new Class[]{A.class, B.class, C.class});
        hsQuery.getTimeoutManager().start();
        entityInfos = hsQuery.queryEntityInfos();
        Assert.assertEquals((long)1L, (long)entityInfos.size());
        Assert.assertEquals((long)2L, (long)sf.getStatistics().getSearchQueryExecutionCount());
        Assert.assertEquals((long)3L, (long)sf.getStatistics().getIndexedClassNames().size());
        hsQuery.getTimeoutManager().stop();
        luceneQuery = parser.parse("Vincent");
        hsQuery = sf.createHSQuery(luceneQuery, new Class[]{A.class, B.class, C.class});
        hsQuery.getTimeoutManager().start();
        entityInfos = hsQuery.queryEntityInfos();
        Assert.assertEquals((long)1L, (long)entityInfos.size());
        Assert.assertEquals((long)3L, (long)sf.getStatistics().getSearchQueryExecutionCount());
        Assert.assertEquals((long)3L, (long)sf.getStatistics().getIndexedClassNames().size());
        hsQuery.getTimeoutManager().stop();
        sf.close();
    }

    private static void doIndexWork(Object entity, Integer id, SearchIntegrator sfi, TransactionContextForTest tc) {
        Work work = new Work(entity, (Serializable)id, WorkType.INDEX);
        sfi.getWorker().performWork(work, (TransactionContext)tc);
    }

    @Test
    public void testMultiThreadedAddClasses() throws Exception {
        QueryParser parser = new QueryParser("name", TestConstants.standardAnalyzer);
        try (final SearchIntegrator sf = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchIntegrator();){
            int numberOfClasses = 100;
            int numberOfThreads = 10;
            new ConcurrentRunner(numberOfClasses, numberOfThreads, new ConcurrentRunner.TaskFactory(){

                @Override
                public Runnable createRunnable(int i) throws Exception {
                    return new DoAddClass(sf, i);
                }
            }).setTimeout(1L, TimeUnit.MINUTES).execute();
            for (int i = 0; i < numberOfClasses; ++i) {
                Query luceneQuery = parser.parse("Emmanuel" + i);
                Class<?> classByNumber = MutableFactoryTest.getClassByNumber(i, sf.getServiceManager());
                HSQuery hsQuery = sf.createHSQuery(luceneQuery, new Class[]{classByNumber});
                int size = hsQuery.queryResultSize();
                Assert.assertEquals((String)("Expected 1 document for class " + classByNumber), (long)1L, (long)size);
            }
        }
    }

    private static Class<?> getClassByNumber(int i, ServiceManager serviceManager) throws ClassNotFoundException {
        ClassLoaderService classLoaderService = serviceManager.getClassLoaderService();
        Class clazz = classLoaderService.classForName(Generated.A0.class.getName().replace("A0", "A" + i));
        return clazz;
    }

    private static class DoAddClass
    implements Runnable {
        private final ExtendedSearchIntegrator extendedIntegrator;
        private final int index;
        private final QueryParser parser;

        public DoAddClass(SearchIntegrator si, int index) {
            this.extendedIntegrator = (ExtendedSearchIntegrator)si.unwrap(ExtendedSearchIntegrator.class);
            this.index = index;
            this.parser = new QueryParser("name", TestConstants.standardAnalyzer);
        }

        @Override
        public void run() {
            try {
                String name = "Emmanuel" + this.index;
                Class aClass = MutableFactoryTest.getClassByNumber(this.index, this.extendedIntegrator.getServiceManager());
                System.err.println("Creating index #" + this.index + " for class " + aClass);
                this.extendedIntegrator.addClasses(new Class[]{aClass});
                Object entity = aClass.getConstructor(Integer.class, String.class).newInstance(this.index, name);
                TransactionContextForTest context = new TransactionContextForTest();
                MutableFactoryTest.doIndexWork(entity, this.index, (SearchIntegrator)this.extendedIntegrator, context);
                context.end();
                EntityIndexBinding indexBindingForEntity = this.extendedIntegrator.getIndexBinding(aClass);
                Assert.assertNotNull((Object)indexBindingForEntity);
                IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
                Assert.assertEquals((long)1L, (long)indexManagers.length);
                Query luceneQuery = this.parser.parse(name);
                HSQuery hsQuery = this.extendedIntegrator.createHSQuery(luceneQuery, new Class[]{aClass});
                Assert.assertEquals((String)("Should have exactly one result for '" + name + "'"), (long)1L, (long)hsQuery.queryResultSize());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Unexpected exception while manipulating dynamically created classes", e);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Unexpected exception while parsing query", e);
            }
        }
    }
}

