/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filters;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-1230")
@Category(value={SkipOnElasticsearch.class})
public class FreshReadersProvidedTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Guest.class);

    @Test
    public void filtersTest() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("guests"));
        Guest lastDwarf = new Guest();
        lastDwarf.id = 13L;
        lastDwarf.name = "Thorin Oakenshield";
        Work work = new Work((Object)lastDwarf, (Serializable)Long.valueOf(lastDwarf.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        QueryBuilder guestQueryBuilder = searchFactory.buildQueryBuilder().forEntity(Guest.class).get();
        Query queryAllGuests = guestQueryBuilder.all().createQuery();
        List queryEntityInfos = searchFactory.createHSQuery(queryAllGuests, new Class[]{Guest.class}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)queryEntityInfos.get(0)).getId());
        RecordingFilter filter = new RecordingFilter("name");
        List filteredQueryEntityInfos = searchFactory.createHSQuery(queryAllGuests, new Class[]{Guest.class}).filter((Filter)filter).queryEntityInfos();
        this.checkFilterInspectedAllSegments(filter);
        this.expectedTermsForFilter(filter, "thorin", "oakenshield");
        Assert.assertEquals((long)1L, (long)filteredQueryEntityInfos.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)filteredQueryEntityInfos.get(0)).getId());
        Guest balin = new Guest();
        balin.id = 7L;
        balin.name = "Balin";
        Work work2 = new Work((Object)balin, (Serializable)Long.valueOf(balin.id), WorkType.ADD, false);
        TransactionContextForTest tc2 = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work2, (TransactionContext)tc2);
        tc2.end();
        List queryEntityInfosAgain = searchFactory.createHSQuery(queryAllGuests, new Class[]{Guest.class}).queryEntityInfos();
        Assert.assertEquals((long)2L, (long)queryEntityInfosAgain.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)queryEntityInfosAgain.get(0)).getId());
        Assert.assertEquals((Object)7L, (Object)((EntityInfo)queryEntityInfosAgain.get(1)).getId());
        RecordingFilter secondFilter = new RecordingFilter("name");
        List secondFilteredQueryEntityInfos = searchFactory.createHSQuery(queryAllGuests, new Class[]{Guest.class}).filter((Filter)secondFilter).queryEntityInfos();
        this.checkFilterInspectedAllSegments(secondFilter);
        this.expectedTermsForFilter(secondFilter, "thorin", "oakenshield", "balin");
        Assert.assertEquals((long)2L, (long)secondFilteredQueryEntityInfos.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)secondFilteredQueryEntityInfos.get(0)).getId());
        Assert.assertEquals((Object)7L, (Object)((EntityInfo)secondFilteredQueryEntityInfos.get(1)).getId());
    }

    private void expectedTermsForFilter(RecordingFilter filter, String ... term) {
        Assert.assertEquals((long)term.length, (long)filter.seenTerms.size());
        Assert.assertTrue((boolean)filter.seenTerms.containsAll(Arrays.asList(term)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFilterInspectedAllSegments(RecordingFilter filter) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        IndexReader currentIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{Guest.class});
        try {
            List<IndexReader> allSubReaders = FreshReadersProvidedTest.getSubIndexReaders((MultiReader)currentIndexReader);
            for (IndexReader ir : allSubReaders) {
                Assert.assertTrue((boolean)filter.visitedReaders.contains(ir));
            }
            for (IndexReader ir : filter.visitedReaders) {
                Assert.assertTrue((boolean)allSubReaders.contains(ir));
            }
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(currentIndexReader);
        }
    }

    public static List<IndexReader> getSubIndexReaders(MultiReader compositeReader) {
        CompositeReaderContext compositeReaderContext = compositeReader.getContext();
        ArrayList<IndexReader> segmentReaders = new ArrayList<IndexReader>(20);
        for (LeafReaderContext readerContext : compositeReaderContext.leaves()) {
            segmentReaders.add((IndexReader)readerContext.reader());
        }
        return segmentReaders;
    }

    @Indexed(index="guests")
    public static final class Guest {
        private long id;
        private String name;

        @DocumentId
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Field
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class RecordingFilter
    extends Filter {
        final List<IndexReader> visitedReaders = new ArrayList<IndexReader>();
        final List<String> seenTerms = new ArrayList<String>();
        final String fieldName;

        public RecordingFilter(String fieldName) {
            this.fieldName = fieldName;
        }

        public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
            LeafReader reader = context.reader();
            this.visitedReaders.add((IndexReader)reader);
            FixedBitSet bitSet = new FixedBitSet(reader.maxDoc());
            for (int i = 0; i < reader.maxDoc(); ++i) {
                bitSet.set(i);
            }
            Terms terms = reader.terms(this.fieldName);
            TermsEnum iterator = terms.iterator();
            BytesRef next = iterator.next();
            while (next != null) {
                this.seenTerms.add(next.utf8ToString());
                next = iterator.next();
            }
            return BitsFilteredDocIdSet.wrap((DocIdSet)new BitDocIdSet((BitSet)bitSet), (Bits)acceptDocs);
        }

        public String toString(String fieldName) {
            return "RecordingFilter(" + this.fieldName + ")";
        }
    }
}

