/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.NumericRangeQuery;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class NumericIdEncodingTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Staff.class);

    @Test
    public void testNumericIdRangeQuery() {
        this.storeTestingData(new Staff(1L, "One"), new Staff(2L, "Two"), new Staff(3L, "Three"), new Staff(4L, "Four"));
        NumericRangeQuery smallRangeQuery = NumericRangeQuery.newLongRange((String)"id", (Long)1L, (Long)3L, (boolean)false, (boolean)false);
        this.expectedProjections((NumericRangeQuery<Long>)smallRangeQuery, "Two");
        NumericRangeQuery universeRangeQuery = NumericRangeQuery.newLongRange((String)"id", null, null, (boolean)false, (boolean)false);
        this.expectedProjections((NumericRangeQuery<Long>)universeRangeQuery, "One", "Two", "Three", "Four");
    }

    private void expectedProjections(NumericRangeQuery<Long> numericRangeQuery, String ... expectedProjections) {
        HSQuery hsQuery = this.factoryHolder.getSearchFactory().createHSQuery(numericRangeQuery, new Class[]{Staff.class}).projection(new String[]{"name"});
        List result = hsQuery.queryEntityInfos();
        Assert.assertEquals((long)expectedProjections.length, (long)result.size());
        Assert.assertEquals((long)expectedProjections.length, (long)hsQuery.queryResultSize());
        for (int i = 0; i < expectedProjections.length; ++i) {
            Assert.assertEquals((Object)expectedProjections[i], (Object)((EntityInfo)result.get(i)).getProjection()[0]);
        }
    }

    private void storeTestingData(Staff ... testData) {
        Worker worker = this.factoryHolder.getSearchFactory().getWorker();
        TransactionContextForTest tc = new TransactionContextForTest();
        for (int i = 0; i < testData.length; ++i) {
            Staff p = testData[i];
            worker.performWork(new Work((Object)p, (Serializable)p.id, WorkType.INDEX), (TransactionContext)tc);
        }
        tc.end();
    }

    @Indexed
    public class Staff {
        @DocumentId
        @NumericField
        final Long id;
        @Field(store=Store.YES)
        final String name;

        Staff(long id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

