/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.engine;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.sort.SortFieldContext;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HSQueryResultCacheClearingTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(IndexedEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void setUp() throws Exception {
        this.helper.add(new IndexedEntity(0, "zero"));
        this.helper.add(new IndexedEntity(1, "one"));
        this.helper.add(new IndexedEntity(2, "two"));
    }

    @Test
    public void clear_firstResult() throws Exception {
        HSQuery hsQuery = this.queryAll();
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        hsQuery.firstResult(1);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2));
        hsQuery.firstResult(2);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    public void clear_maxResult() throws Exception {
        HSQuery hsQuery = this.queryAll();
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        hsQuery.maxResults(2);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1));
        hsQuery.maxResults(1);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0));
    }

    @Test
    public void clear_projection() throws Exception {
        HSQuery hsQuery = this.queryAll();
        hsQuery.projection(new String[]{"__HSearch_id"});
        this.helper.assertThat(hsQuery).matchesExactlySingleProjections(0, 1, 2);
        hsQuery.projection(new String[]{"__HSearch_id", "field"});
        this.helper.assertThat(hsQuery).matchesExactlyProjections({0, "zero"}, {1, "one"}, {2, "two"});
    }

    @Test
    public void clear_sort() throws Exception {
        QueryBuilder qb = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery hsQuery = this.queryAll();
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        hsQuery.sort(((SortFieldContext)qb.sort().byField("idSort").desc()).createSort());
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0));
    }

    @Test
    public void clear_faceting() throws Exception {
        QueryBuilder qb = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery hsQuery = this.queryAll();
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        String facetingRequestName = "facet1";
        FacetingRequest facetingRequest1 = qb.facet().name(facetingRequestName).onField("facetField").discrete().createFacetingRequest();
        hsQuery.getFacetManager().enableFaceting(facetingRequest1);
        this.helper.assertThat(hsQuery).facets(facetingRequestName).includes("zero", 1).includes("one", 1).includes("two", 1).only();
        hsQuery.getFacetManager().disableFaceting(facetingRequestName);
        this.helper.assertThat(hsQuery).facets(facetingRequestName).isEmpty();
    }

    @Test
    public void clear_fullTextFilter() throws Exception {
        HSQuery hsQuery = this.queryAll();
        this.helper.assertThat(hsQuery).hasResultSize(3);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        String filterName = "keepOnlyValueOne";
        hsQuery.enableFullTextFilter(filterName);
        this.helper.assertThat(hsQuery).hasResultSize(1);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(1));
        hsQuery.disableFullTextFilter(filterName);
        this.helper.assertThat(hsQuery).hasResultSize(3);
        this.helper.assertThat(hsQuery).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    }

    private HSQuery queryAll() {
        QueryBuilder qb = this.helper.queryBuilder(IndexedEntity.class);
        return this.helper.hsQuery(IndexedEntity.class).sort(qb.sort().byField("idSort").createSort());
    }

    public static class KeepOnlyValueOneFilter {
        @Factory
        public Filter create() {
            return new QueryWrapperFilter((Query)new BooleanQuery.Builder().add((Query)new TermQuery(new Term("field", "one")), BooleanClause.Occur.MUST).build());
        }
    }

    @Indexed
    @FullTextFilterDef(name="keepOnlyValueOne", impl=KeepOnlyValueOneFilter.class)
    private static class IndexedEntity {
        @DocumentId
        @Field(name="idSort")
        @SortableField(forField="idSort")
        private Integer id;
        @Fields(value={@Field(store=Store.YES, analyze=Analyze.NO), @Field(name="facetField", analyze=Analyze.NO)})
        @SortableField
        @Facet(forField="facetField")
        private String field;

        public IndexedEntity(Integer id, String field) {
            this.id = id;
            this.field = field;
        }
    }
}

