/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.concurrency;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class ConcurrentRunner {
    public static final int DEFAULT_REPEAT = 300;
    public static final int DEFAULT_THREADS = 30;
    private final ConcurrentMap<Integer, Throwable> failures = new ConcurrentHashMap<Integer, Throwable>(0);
    private final ExecutorService executor;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch endLatch;
    private final TaskFactory factory;
    private final int repetitions;
    private Long timeoutValue;
    private TimeUnit timeoutUnit;

    public ConcurrentRunner(TaskFactory factory) {
        this(300, 30, factory);
    }

    public ConcurrentRunner(int repetitions, int threads, TaskFactory factory) {
        this.repetitions = repetitions;
        this.factory = factory;
        this.executor = Executors.newFixedThreadPool(threads);
        this.endLatch = new CountDownLatch(repetitions);
    }

    public ConcurrentRunner setTimeout(long timeoutValue, TimeUnit timeoutUnit) {
        this.timeoutValue = timeoutValue;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public void execute() throws Exception, AssertionError {
        for (int i = 0; i < this.repetitions; ++i) {
            Runnable userRunnable = this.factory.createRunnable(i);
            this.executor.execute(new WrapRunnable(this.startLatch, this.endLatch, i, userRunnable));
        }
        this.executor.shutdown();
        this.startLatch.countDown();
        boolean timedOut = false;
        try {
            if (this.timeoutValue != null) {
                if (!this.endLatch.await(this.timeoutValue, this.timeoutUnit)) {
                    this.executor.shutdownNow();
                    timedOut = true;
                }
            } else {
                this.endLatch.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
            Assert.fail((String)"Interrupted while awaiting for end of execution");
        }
        AssertionError reportedError = null;
        if (timedOut) {
            reportedError = new AssertionError((Object)("The thread pool didn't finish executing after " + this.timeoutValue + " " + (Object)((Object)this.timeoutUnit)));
        }
        for (Map.Entry entry : this.failures.entrySet()) {
            if (reportedError == null) {
                reportedError = new AssertionError("Unexpected failure on task #" + entry.getKey(), (Throwable)entry.getValue());
                continue;
            }
            ((Throwable)((Object)reportedError)).addSuppressed((Throwable)entry.getValue());
        }
        if (reportedError != null) {
            throw reportedError;
        }
    }

    public static interface TaskFactory {
        public Runnable createRunnable(int var1) throws Exception;
    }

    private class WrapRunnable
    implements Runnable {
        private final CountDownLatch startLatch;
        private final CountDownLatch endLatch;
        private final Integer taskIndex;
        private final Runnable userRunnable;

        public WrapRunnable(CountDownLatch startLatch, CountDownLatch endLatch, Integer taskIndex, Runnable userRunnable) {
            this.startLatch = startLatch;
            this.endLatch = endLatch;
            this.taskIndex = taskIndex;
            this.userRunnable = userRunnable;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                if (ConcurrentRunner.this.failures.isEmpty()) {
                    this.userRunnable.run();
                }
            }
            catch (AssertionError | InterruptedException | RuntimeException e) {
                ConcurrentRunner.this.failures.put(this.taskIndex, e);
            }
            this.endLatch.countDown();
        }
    }
}

