/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

public class AsyncBackendFlushTest {
    private static final int ENTITIES = 100;
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Quote.class).withProperty("hibernate.search.default.worker.execution", "async");
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testFlush() throws Exception {
        this.writeData(0, 50);
        this.flushIndex();
        this.assertDocumentsIndexed(50);
        this.writeData(50, 100);
        this.flushIndex();
        this.assertDocumentsIndexed(100);
    }

    private void flushIndex() {
        this.sfHolder.extractIndexManager(Quote.class).flushAndReleaseResources();
    }

    private void assertDocumentsIndexed(int number) {
        this.helper.assertThat().from(Quote.class).hasResultSize(number);
    }

    private void writeData(int fromId, int toId) {
        for (int i = fromId; i < toId; ++i) {
            Quote quote = new Quote(i, Quote.class.getName());
            this.helper.add(quote);
        }
    }
}

