/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.ZoneOffset;
import org.fest.assertions.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.ZoneOffsetBridge;
import org.junit.Test;

public class ZoneOffsetBridgeTest {
    private static final ZoneOffsetBridge BRIDGE = ZoneOffsetBridge.INSTANCE;
    private static final ZoneOffset MAX_VALUE = ZoneOffset.MAX;
    private static final ZoneOffset MIN_VALUE = ZoneOffset.MIN;
    private static final ZoneOffset CUSTOM_VALUE = ZoneOffset.UTC;
    private static final String MAX = "+18:00";
    private static final String MIN = "-18:00";
    private static final String CST = "Z";

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_VALUE)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_VALUE)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_VALUE)).isEqualTo((Object)CST);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_VALUE);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_VALUE);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CST)).isEqualTo((Object)CUSTOM_VALUE);
    }
}

