/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.test.dsl.CoffeeBrand;

@Indexed
class Coffee {
    public static final String NAME_SORT = "name_sort";
    private String id;
    private String name;
    private String summary;
    private String description;
    private int intensity;
    private String internalDescription;
    private CoffeeBrand brand;

    Coffee() {
    }

    @DocumentId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Fields(value={@Field(termVector=TermVector.NO, store=Store.YES), @Field(name="name_sort", analyze=Analyze.NO)})
    @SortableField(forField="name_sort")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(termVector=TermVector.YES)
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Field(termVector=TermVector.YES)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
    }

    @Field
    public String getInternalDescription() {
        return this.internalDescription;
    }

    public void setInternalDescription(String internalDescription) {
        this.internalDescription = internalDescription;
    }

    @IndexedEmbedded(includeEmbeddedObjectId=true)
    public CoffeeBrand getBrand() {
        return this.brand;
    }

    public void setBrand(CoffeeBrand brand) {
        this.brand = brand;
    }

    public String toString() {
        return "Coffee{id=" + this.id + ", name='" + this.name + '\'' + ", summary='" + this.summary + '\'' + ", description='" + this.description + '\'' + ", intensity=" + this.intensity + '}';
    }
}

