/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.metadata.DummyIndexManager;

public final class DescriptorTestHelper {
    public static final List<String> TEST_INDEX_NAMES = Arrays.asList("index-0", "index-0", "index-0");

    private DescriptorTestHelper() {
    }

    @Deprecated
    public static IndexedTypeDescriptor getTypeDescriptor(AnnotationMetadataProvider metadataProvider, Class<?> clazz) {
        return DescriptorTestHelper.getTypeDescriptor(metadataProvider, (IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(clazz));
    }

    public static IndexedTypeDescriptor getTypeDescriptor(AnnotationMetadataProvider metadataProvider, IndexedTypeIdentifier type) {
        TypeMetadata typeMetadata = metadataProvider.getTypeMetadataFor(type, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        return new IndexedTypeDescriptorImpl(typeMetadata, DescriptorTestHelper.getDummyUnShardedIndexManager());
    }

    public static Set<IndexManager> getDummyUnShardedIndexManager() {
        DummyIndexManager indexManager = new DummyIndexManager(TEST_INDEX_NAMES.get(0));
        return Collections.singleton(indexManager);
    }

    public static Set<IndexManager> getDummyShardedIndexManager() {
        HashSet<IndexManager> managers = new HashSet<IndexManager>();
        int i = 0;
        for (String indexName : TEST_INDEX_NAMES) {
            managers.add(new DummyIndexManager(indexName));
            ++i;
        }
        return managers;
    }
}

