/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdef;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.ngram.EdgeNGramFilterFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilterFactory;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2606")
public class AnalyzerDefInvalidTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    private SearchIntegrator integrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.integrator);
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();

    @Test
    public void shouldNotBePossibleToHaveTwoAnalyzerParametersWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("Conflicting usage of @Parameter annotation for parameter name: 'maxGramSize'. Can't assign both value '15' and '1'");
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithAnalyzer.class);
        this.integratorResource.create(cfg);
    }

    @Test
    public void shouldNotBePossibleToHaveTwoNormalizerParametersWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("Conflicting usage of @Parameter annotation for parameter name: 'pattern'. Can't assign both value '[[:digit:]]' and '[[:digit:]]+'");
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithNormalizer.class);
        this.integratorResource.create(cfg);
    }

    @Test
    public void shouldNotBePossibleToHaveEmptyNormalizer() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000343");
        this.thrown.expectMessage("'empty_normalizer'");
        this.thrown.expectMessage("must define at least a char filter or a token filter");
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithEmptyNormalizer.class);
        this.integratorResource.create(cfg);
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void shouldWarnOnTokenizingNormalizerDefinition() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithTokenizingNormalizerDefinition.class);
        this.integrator = this.integratorResource.create(cfg);
        this.logged.expectMessage("HSEARCH000344", "'tokenizing_normalizer'", "3 tokens");
        SampleWithTokenizingNormalizerDefinition entity = new SampleWithTokenizingNormalizerDefinition();
        entity.id = 1L;
        entity.description = "to be tokenized";
        this.helper.add((Object)entity, Long.valueOf(entity.id));
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void shouldWarnOnTokenizingNormalizerImplementation() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithTokenizingNormalizerImplementation.class);
        this.integrator = this.integratorResource.create(cfg);
        this.logged.expectMessage("HSEARCH000344", "'" + StandardAnalyzer.class.getName() + "'", "2 tokens");
        SampleWithTokenizingNormalizerImplementation entity = new SampleWithTokenizingNormalizerImplementation();
        entity.id = 1L;
        entity.description = "a description to be tokenized";
        this.helper.add((Object)entity, Long.valueOf(entity.id));
    }

    @Test
    public void shouldWarnOnSortableFieldWithNonNormalizerAnalyzer() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithTokenizedSortableField.class);
        this.logged.expectMessage("HSEARCH000345", "'" + SampleWithTokenizedSortableField.class.getName() + "'", "'sortableField'", "Sortable fields should be assigned normalizers");
        this.integratorResource.create(cfg);
    }

    public static final class CustomFilterFactory
    extends TokenFilterFactory {
        public CustomFilterFactory(Map<String, String> args) {
            super(args);
        }

        public TokenStream create(TokenStream input) {
            return new TokenFilter(input){
                private final Deque<String> nextTokens;
                private final CharTermAttribute termAtt;
                {
                    super(x0);
                    this.nextTokens = new ArrayDeque<String>();
                    this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                }

                public boolean incrementToken() throws IOException {
                    if (!this.nextTokens.isEmpty()) {
                        this.termAtt.setEmpty().append(this.nextTokens.removeFirst());
                        return true;
                    }
                    if (this.input.incrementToken()) {
                        for (String token : this.termAtt.toString().split(" ")) {
                            this.nextTokens.addLast(token);
                        }
                        if (!this.nextTokens.isEmpty()) {
                            this.termAtt.setEmpty().append(this.nextTokens.removeFirst());
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
    }

    @Indexed
    @AnalyzerDef(name="tokenizing_analyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class))
    static class SampleWithTokenizedSortableField {
        @DocumentId
        long id;
        @Field(analyzer=@Analyzer(definition="tokenizing_analyzer"))
        @SortableField
        String sortableField;

        SampleWithTokenizedSortableField() {
        }
    }

    @Indexed
    static class SampleWithTokenizingNormalizerImplementation {
        @DocumentId
        long id;
        @Field(normalizer=@Normalizer(impl=StandardAnalyzer.class))
        String description;

        SampleWithTokenizingNormalizerImplementation() {
        }
    }

    @Indexed
    @NormalizerDef(name="tokenizing_normalizer", filters={@TokenFilterDef(factory=CustomFilterFactory.class)})
    static class SampleWithTokenizingNormalizerDefinition {
        @DocumentId
        long id;
        @Field(normalizer=@Normalizer(definition="tokenizing_normalizer"))
        String description;

        SampleWithTokenizingNormalizerDefinition() {
        }
    }

    @Indexed
    @NormalizerDef(name="empty_normalizer")
    static class SampleWithEmptyNormalizer {
        @DocumentId
        long id;
        @Field(normalizer=@Normalizer(definition="empty_normalizer"))
        String description;

        SampleWithEmptyNormalizer() {
        }
    }

    @Indexed
    @NormalizerDef(name="ngram", charFilters={@CharFilterDef(factory=PatternReplaceCharFilterFactory.class, params={@Parameter(name="pattern", value="[[:digit:]]+"), @Parameter(name="pattern", value="[[:digit:]]"), @Parameter(name="replacement", value="0")})})
    static class SampleWithNormalizer {
        @DocumentId
        long id;
        @Field(normalizer=@Normalizer(definition="ngram"))
        String description;

        SampleWithNormalizer() {
        }
    }

    @Indexed
    @AnalyzerDef(name="ngram", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=EdgeNGramFilterFactory.class, params={@Parameter(name="maxGramSize", value="1"), @Parameter(name="maxGramSize", value="15")})})
    static class SampleWithAnalyzer {
        @DocumentId
        long id;
        @Field(analyzer=@Analyzer(definition="ngram"))
        String description;

        SampleWithAnalyzer() {
        }
    }
}

