/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.DeleteByQuerySupport;
import org.hibernate.search.backend.spi.DeleteByQueryWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.SingularTermDeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DeleteByQueryTest {
    private static final IndexedTypeIdentifier BOOK_TYPE = new PojoIndexedTypeIdentifier(Book.class);
    private static final IndexedTypeIdentifier MOVIE_TYPE = new PojoIndexedTypeIdentifier(Movie.class);
    @Rule
    public final SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Book.class, Movie.class);
    private final SearchITHelper helper = new SearchITHelper(this.factoryHolder);

    @Test
    public void testStringSerialization() {
        for (DeletionQuery q : this.buildQueries()) {
            this.testSerializationForQuery(q);
        }
    }

    private List<DeletionQuery> buildQueries() {
        ArrayList<DeletionQuery> l = new ArrayList<DeletionQuery>();
        l.add((DeletionQuery)new SingularTermDeletionQuery("id", "123"));
        l.addAll(this.buildNumQueries());
        return l;
    }

    private List<SingularTermDeletionQuery> buildNumQueries() {
        ArrayList<SingularTermDeletionQuery> l = new ArrayList<SingularTermDeletionQuery>();
        l.add(new SingularTermDeletionQuery("intField", 1));
        l.add(new SingularTermDeletionQuery("longField", 1L));
        l.add(new SingularTermDeletionQuery("floatField", 1.0f));
        l.add(new SingularTermDeletionQuery("doubleField", 1.0));
        return l;
    }

    private List<Integer> expectedCount() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(1);
        l.add(1);
        l.add(1);
        return l;
    }

    @Test
    public void testSingularTermQuery() {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        Worker worker = integrator.getWorker();
        this.makeBooksForSingularTermQuery();
        this.assertCount(Book.class, 2);
        TransactionContextForTest tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(BOOK_TYPE, (DeletionQuery)new SingularTermDeletionQuery("url", "lordoftherings")), (TransactionContext)tc);
        tc.end();
        this.assertCount(Book.class, 1);
        tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(BOOK_TYPE, (DeletionQuery)new SingularTermDeletionQuery("url", "thehobbit")), (TransactionContext)tc);
        tc.end();
        this.assertCount(Book.class, 0);
    }

    @Test
    public void testStringIdTermQuery() {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        Worker worker = integrator.getWorker();
        this.makeBooksForSingularTermQuery();
        this.assertCount(Book.class, 2);
        TransactionContextForTest tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(BOOK_TYPE, (DeletionQuery)new SingularTermDeletionQuery("id", String.valueOf(5))), (TransactionContext)tc);
        tc.end();
        this.assertCount(Book.class, 1);
        tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(BOOK_TYPE, (DeletionQuery)new SingularTermDeletionQuery("id", String.valueOf(6))), (TransactionContext)tc);
        tc.end();
        this.assertCount(Book.class, 0);
    }

    @Test
    public void testNumericIdTermQuery() {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        Worker worker = integrator.getWorker();
        this.makeMoviesForNumericIdTermQuery();
        this.assertCount(Movie.class, 2);
        TransactionContextForTest tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(MOVIE_TYPE, (DeletionQuery)new SingularTermDeletionQuery("id", 3)), (TransactionContext)tc);
        tc.end();
        this.assertCount(Movie.class, 1);
        tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(MOVIE_TYPE, (DeletionQuery)new SingularTermDeletionQuery("id", 4)), (TransactionContext)tc);
        tc.end();
        this.assertCount(Movie.class, 0);
    }

    @Test
    public void testNumRangeQuery() {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        List<SingularTermDeletionQuery> numQueries = this.buildNumQueries();
        List<Integer> expectedCount = this.expectedCount();
        Assert.assertEquals((long)expectedCount.size(), (long)numQueries.size());
        for (int i = 0; i < numQueries.size(); ++i) {
            try {
                this.testForQuery(Book.class, integrator, (DeletionQuery)numQueries.get(i), expectedCount.get(i));
                continue;
            }
            catch (Throwable e) {
                System.out.println("ERROR: " + numQueries.get(i) + ". expected was: " + expectedCount.get(i));
                throw e;
            }
        }
    }

    private void testForQuery(Class<?> entityType, ExtendedSearchIntegrator integrator, DeletionQuery query, int expectedCount) {
        Worker worker = integrator.getWorker();
        this.makeBooksForNumRangeQuery();
        this.assertCount(entityType, 2);
        TransactionContextForTest tc = new TransactionContextForTest();
        worker.performWork((Work)new DeleteByQueryWork(BOOK_TYPE, query), (TransactionContext)tc);
        tc.end();
        this.assertCount(entityType, expectedCount);
        tc = new TransactionContextForTest();
        worker.performWork(new Work(BOOK_TYPE, null, WorkType.PURGE_ALL), (TransactionContext)tc);
        tc.end();
        this.assertCount(entityType, 0);
    }

    private void assertCount(Class<?> entityType, int count) {
        this.helper.assertThat().from(entityType).hasResultSize(count);
    }

    private void testSerializationForQuery(DeletionQuery deletionQuery) {
        Assert.assertTrue((boolean)DeleteByQuerySupport.isSupported(deletionQuery.getClass()));
        String[] strRep = deletionQuery.serialize();
        DeletionQuery copy = DeleteByQuerySupport.fromString((int)deletionQuery.getQueryKey(), (String[])strRep);
        Assert.assertEquals((Object)deletionQuery, (Object)copy);
    }

    private void makeBooksForSingularTermQuery() {
        this.helper.add(new Book(String.valueOf(5), "Lord of The Rings", "lordoftherings"), new Book(String.valueOf(6), "The Hobbit", "thehobbit"));
    }

    private void makeMoviesForNumericIdTermQuery() {
        this.helper.add(new Movie(3, "Cashback"), new Movie(4, "Garden state"));
    }

    private void makeBooksForNumRangeQuery() {
        this.helper.add(new Book(String.valueOf(5), 1, 1L, Float.valueOf(1.0f), 1.0, "Lord of The Rings", "lordoftherings"), new Book(String.valueOf(6), 2, 2L, Float.valueOf(2.0f), 2.0, "The Hobbit", "thehobbit"));
    }

    @Indexed(index="movies")
    private static class Movie {
        @DocumentId
        Integer id;
        @Field
        String title;

        public Movie(Integer id, String title) {
            this.id = id;
            this.title = title;
        }
    }

    @Indexed(index="books")
    private static class Book {
        @DocumentId
        String id;
        @Field(store=Store.YES, index=Index.YES)
        Integer intField;
        @Field(store=Store.YES, index=Index.YES)
        Long longField;
        @Field(store=Store.YES, index=Index.YES)
        Float floatField;
        @Field(store=Store.YES, index=Index.YES)
        Double doubleField;
        @Field
        String title;
        @Field
        String url;

        public Book(String id, String title, String url) {
            this.id = id;
            this.title = title;
            this.url = url;
        }

        public Book(String id, Integer intField, Long longField, Float floatField, Double doubleField, String title, String url) {
            this.id = id;
            this.intField = intField;
            this.longField = longField;
            this.floatField = floatField;
            this.doubleField = doubleField;
            this.title = title;
            this.url = url;
        }
    }
}

